package ru.yandex.autotests.directapi.banners.tags.getbannerstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.GET_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки баннера по протоколу SOAP")
public class GetBannersTagsSOAPTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long bannerID;
    private static int tagID;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createCampaign() {
        api.protocol(ProtocolType.JSON);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, "Тэг");
        assumeThat("добавилось две метки", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];
        int request = api.userSteps.tagSteps().updateBannerTags(bannerID, tagID);
        assumeThat("успешный вызов " + Method.UPDATE_BANNERS_TAGS, request, equalTo(1));
    }

    @Test
    @Title("Проверка работоспособности SOAP")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8604")
    public void soapTest() {
        api.protocol(ProtocolType.SOAP);
        BannerTagsInfo[] bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(bannerID));
        assertThat("результат соответствует ожидаемому", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(tagID).getBean()}));
    }
}
