package ru.yandex.autotests.directapi.banners.tags.getbannerstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.GET_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки баннеров")
public class GetBannersTagsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long firstCampaignID;
    private static Long firstBannerID;
    private static int firstTagID;

    private static Long secondCampaignID;
    private static Long secondBannerID;
    private static int secondTagID;

    @BeforeClass
    public static void createCampaign() {
        firstCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        firstBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(firstCampaignID);
        int[] firstTagIDS = api.userSteps.tagSteps().addTags(firstCampaignID, "Tag");
        assumeThat("добавилась одна метка для первой кампании", firstTagIDS.length, equalTo(1));
        firstTagID = firstTagIDS[0];

        secondCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        secondBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(secondCampaignID);
        int[] secondTagIDS = api.userSteps.tagSteps().addTags(secondCampaignID, "Tag");
        assumeThat("добавилась одна метка для второй кампании", secondTagIDS.length, equalTo(1));
        secondTagID = secondTagIDS[0];

        int updateBannersTagsResponse = api.userSteps.tagSteps().updateBannersTags(
                new BannerTagsInfoMap(api.type())
                        .withBannerID(firstBannerID)
                        .withTags(firstTagID),
                new BannerTagsInfoMap(api.type())
                        .withBannerID(secondBannerID)
                        .withTags(secondTagID));
        assumeThat("метки для баннеров добавились успешно", updateBannersTagsResponse, equalTo(1));
    }

    @Test
    @Title("Метки одного баннера")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8610")
    public void bannerTagsOfOneBanner() {
        BannerTagsInfo[] bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(firstBannerID));

        assertThat("результат соответствует ожидаемому", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(firstBannerID)
                        .withTags(firstTagID).getBean()}));
    }

    @Test
    @Title("Метки баннера одной кампании")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8609")
    public void bannerTagsOfBannerOfOneCampaign() {
        BannerTagsInfo[] bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withCampaignIDS(firstCampaignID.intValue()));

        assertThat("результат соответствует ожидаемому", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(firstBannerID)
                        .withTags(firstTagID).getBean()}));
    }

    @Test
    @Title("Метки двух баннеров")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8607")
    public void bannerTagsOfTwoBanners() {
        BannerTagsInfo[] bannerTagsInfos = sort(api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(firstBannerID, secondBannerID)),
                on(BannerTagsInfo.class).getBannerID()).toArray(new BannerTagsInfo[0]);

        assertThat("результат соответствует ожидаемому", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(firstBannerID)
                        .withTags(firstTagID).getBean(),
                new BannerTagsInfoMap(api.type())
                        .withBannerID(secondBannerID)
                        .withTags(secondTagID).getBean()}));
    }

    @Test
    @Title("Метки баннеров двух кампаний")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8608")
    public void bannerTagsOfBannersOfTwoCampaigns() {
        BannerTagsInfo[] bannerTagsInfos = sort(api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withCampaignIDS(firstCampaignID.intValue(), secondCampaignID.intValue())),
                on(BannerTagsInfo.class).getBannerID()).toArray(new BannerTagsInfo[0]);

        assertThat("результат соответствует ожидаемому", bannerTagsInfos, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(firstBannerID)
                        .withTags(firstTagID).getBean(),
                new BannerTagsInfoMap(api.type())
                        .withBannerID(secondBannerID)
                        .withTags(secondTagID).getBean()}));
    }
}
