package ru.yandex.autotests.directapi.banners.tags.getbannerstags.roles;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayWithSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.GET_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки баннеров: внутренние роли")
public class GetBannersTagsInternalRolesRightsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String login;

    private static Long campaignId;
    private static Long bannerID;

    @Parameterized.Parameters(name = "Логин пользователя: {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {Logins.MEDIA},
                {Logins.SUPER_READER},
                {Logins.PLACER},
                {Logins.SUPPORT},
                {Logins.SUPER_LOGIN}
        });
    }

    @BeforeClass
    public static void createCampaign() {
        api.as(BannerLogins.CLIENT_SELF);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8613")
    public void checkGetBannersTagsResponse() {
        api.as(login);
        BannerTagsInfo[] bannerTagsInfos = api.userSteps.tagSteps().getBannersTags(
                new BannersRequestInfoMap(api.type())
                        .withBannerIDS(bannerID));
        assertThat("метод отработал успешно", bannerTagsInfos, arrayWithSize(1));
    }
}
