package ru.yandex.autotests.directapi.banners.tags.getcampaignstags;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/11/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.GET_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки кампании: валидация типов в JSON")
public class GetCampaignsJsonValidationTest {

    private static final String STRING_VALUE = "stringValue";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Title(CampaignIDsInfoMap.CAMPAIGN_IDS + " типа int")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8614")
    public void campaignIdOfIntegerType() {
        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignIDsInfoMap.CAMPAIGN_IDS), campaignId);
        api.userSteps.shouldGetErrorOn(
                Method.GET_CAMPAIGNS_TAGS,
                request,
                new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY,
                        capitalize(CampaignIDsInfoMap.CAMPAIGN_IDS)));
    }

    @Test
    @Title("Строка в массиве " + CampaignIDsInfoMap.CAMPAIGN_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8615")
    public void stringInCampaignIdArray() {
        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignIDsInfoMap.CAMPAIGN_IDS), new Object[]{campaignId, STRING_VALUE});
        api.userSteps.shouldGetErrorOn(
                Method.GET_CAMPAIGNS_TAGS,
                request,
                new AxisError(71, AxisErrorDetails.ARRAY_MUST_CONTAIN_INTEGER_VALUES,
                        capitalize(CampaignIDsInfoMap.CAMPAIGN_IDS)));
    }
}
