package ru.yandex.autotests.directapi.banners.tags.getcampaignstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.campaigns.CampaignIDsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(BannerFeatures.GET_CAMPAIGNS_TAGS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class GetCampaignsTagsForNonTextCampaignNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static final String TAG_FOR_TEXT = "tagForTextCamp";
    private static int[] nonTextTagsIDS;
    private static int[] textTagsIDS;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB}
        });
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns() {
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        nonTextTagsIDS = api.userSteps.tagSteps().addTags(nonTextCampaignId, TAG_FOR_MOBILE);
        assumeThat("метка создалась", nonTextTagsIDS.length, equalTo(1));

        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textTagsIDS = api.userSteps.tagSteps().addTags(textCampaignId, TAG_FOR_TEXT);
        assumeThat("метка создалась", textTagsIDS.length, equalTo(1));
    }

    @Before
    public void setType() {
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8617")
    public void getNonTextCampaignTags() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_CAMPAIGNS_TAGS,
                new CampaignIDsInfoMap(api.type())
                        .withCampaignIDs(nonTextCampaignId.intValue()).getBean(),
                new AxisError(3500));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8618")
    public void getNonTextAndTextCampaignsTags() {
        api.userSteps.shouldGetErrorOn(
                Method.GET_CAMPAIGNS_TAGS,
                new CampaignIDsInfoMap(api.type())
                        .withCampaignIDs(nonTextCampaignId.intValue(), textCampaignId.intValue()).getBean(),
                new AxisError(3500));
    }
}
