package ru.yandex.autotests.directapi.banners.tags.getcampaignstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/12/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.GET_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки кампаний для пользователя с одной кампанией")
public class GetCampaignsTagsForOneCampaignTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static int firstTagID;
    private static int secondTagID;

    private static final String FIRST_TAG = "firstTag";
    private static final String SECOND_TAG = "secondTag";

    @BeforeClass
    public static void createCampaigns() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagsIDS = api.userSteps.tagSteps().addTags(campaignId, FIRST_TAG, SECOND_TAG);
        assumeThat("для кампании создались две метки", tagsIDS.length, equalTo(2));
        firstTagID = tagsIDS[0];
        secondTagID = tagsIDS[1];
    }

    @Test
    @Title("Кампания с двумя метками")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8623")
    public void getCampaignTags() {
        CampaignTagsInfo[] campaignTagsInfos = api.userSteps.tagSteps().getCampaignsTags(campaignId);

        assertThat("результат соответствует ожидаемому", campaignTagsInfos, beanDiffer(new Object[]{
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(firstTagID)
                                        .withTag(FIRST_TAG),
                                new TagInfoMap(api.type())
                                        .withTagID(secondTagID)
                                        .withTag(SECOND_TAG)).getBean()}));
    }
}
