package ru.yandex.autotests.directapi.banners.tags.getcampaignstags;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/12/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.GET_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Получить метки кампаний для пользователя с двумя кампаниями")
public class GetCampaignsTagsForTwoCampaigsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long firstCampaignID;
    private static int firstTagID;
    private static Long secondCampaignID;
    private static int secondTagID;

    private static final String FIRST_TAG = "firstTag";
    private static final String SECOND_TAG = "secondTag";

    @BeforeClass
    public static void createCampaigns() {
        firstCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] firstTagsIDS = api.userSteps.tagSteps().addTags(firstCampaignID, FIRST_TAG);
        assumeThat("для первой кампании создалась одна метка", firstTagsIDS.length, equalTo(1));
        firstTagID = firstTagsIDS[0];

        secondCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] secondTagsIDS = api.userSteps.tagSteps().addTags(secondCampaignID, SECOND_TAG);
        assumeThat("для второй кампании создалась одна метка", secondTagsIDS.length, equalTo(1));
        secondTagID = secondTagsIDS[0];
    }

    @Test
    @Title("Метки для одной кампании")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8625")
    public void getCampaignTagsForOneCampaign() {
        CampaignTagsInfo[] campaignTagsInfos = api.userSteps.tagSteps().getCampaignsTags(firstCampaignID);

        assertThat("результат соответствует ожидаемому", campaignTagsInfos, beanDiffer(new Object[]{
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(firstCampaignID.intValue())
                        .withTags(new TagInfoMap(api.type())
                                .withTagID(firstTagID)
                                .withTag(FIRST_TAG)).getBean()}));
    }

    @Test
    @Title("Метки для двух кампаний")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8626")
    public void getCampaignTagsForTwoCampaigns() {
        CampaignTagsInfo[] campaignTagsInfos = sort(api.userSteps.tagSteps().getCampaignsTags(
                firstCampaignID, secondCampaignID),
                on(CampaignTagsInfo.class).getCampaignID()).toArray(new CampaignTagsInfo[0]);

        assertThat("результат соответствует ожидаемому", campaignTagsInfos, beanDiffer(new Object[]{
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(firstCampaignID.intValue())
                        .withTags(new TagInfoMap(api.type())
                                .withTagID(firstTagID)
                                .withTag(FIRST_TAG)).getBean(),
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(secondCampaignID.intValue())
                        .withTags(new TagInfoMap(api.type())
                                .withTagID(secondTagID)
                                .withTag(SECOND_TAG)).getBean()}));
    }
}
