package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayContainingInAnyOrder;
import static org.hamcrest.Matchers.emptyArray;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.TAGS)
@Description("Создать метки для одного баннера")
public class UpdateBannersTagsCreateForOneBannerTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private Integer firstTagID;
    private Integer secondTagID;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, "Tag1", "Tag2");
        assumeThat("в кампанию добавилось две метки", tagIDS.length, equalTo(2));
        firstTagID = tagIDS[0];
        secondTagID = tagIDS[1];

        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Две метки")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8632")
    public void twoBannerTags() {
        api.userSteps.tagSteps().updateBannersTags(new BannerTagsInfoMap(api.type())
                .withBannerID(bannerID)
                .withTags(firstTagID, secondTagID));
        BannerTagsInfo[] response = api.userSteps.tagSteps().getBannersTags(new BannersRequestInfoMap(api.type())
                .withBannerIDS(bannerID));
        assumeThat("вернулся не пустой ответ", response, not(emptyArray()));
        Integer[] tagIDs = ArrayUtils.toObject(response[0].getTagIDS());

        assertThat("результат соответствует ожидаемому", tagIDs, arrayContainingInAnyOrder(firstTagID, secondTagID));
    }
}
