package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 02.11.15.
 * https://st.yandex-team.ru/TESTIRT-7576
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Issue("https://st.yandex-team.ru/DIRECT-46327")
@Description("Обновление тегов объявлений из разных кампаний")
public class UpdateBannersTagsForDifferentCampaignsTest {

    private static final String LOGIN = BannerLogins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long bannerId1;
    private int tagId1;

    private Long bannerId2;
    private int tagId2;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        Long campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerId1 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId1);
        int[] tagIDs = api.userSteps.tagSteps().addTags(campaignId1, "Tag1");
        assumeThat("в кампанию добавилась одна метка", tagIDs.length, equalTo(1));
        tagId1 = tagIDs[0];

        Long campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerId2 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId2);
        tagIDs = api.userSteps.tagSteps().addTags(campaignId2, "Tag2");
        assumeThat("в кампанию добавилась одна метка", tagIDs.length, equalTo(1));
        tagId2 = tagIDs[0];
    }

    @Test
    @Description("Получение ключевых слов для двух объявлений из разных кампаний")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8867")
    public void keywordGetForTwoBannersFromDifferentCampaigns() {
        int response = api.userSteps.tagSteps().updateBannersTags(
                new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerId1)
                        .withTags(tagId1),
                new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerId2)
                        .withTags(tagId2));
        assertThat("в ответе получили единицу", response, equalTo(1));
    }
}
