package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями под чужим логином.")
@RunWith(Parameterized.class)
public class UpdateBannersTagsForNonTextCampaignRightsTest {
    public static String anotherClient = Logins.CLIENT_DOT_LOGIN;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static final String TAG_FOR_MOBILE2 = "tagForMobileCamp2";
    private static int[] nonTextTagsIDS;
    private static Long nonTextBannerId;

    @Rule
    public Trashman trasher = new Trashman(api);
    private BannerTagsInfo[] bannerTagsInfos;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE}});
    }

    @Before
    public void createNonTextCampaigns(){
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        nonTextTagsIDS = api.userSteps.tagSteps().addTags(nonTextCampaignId, TAG_FOR_MOBILE, TAG_FOR_MOBILE2);
        nonTextBannerId = api.userSteps.addCompletedAdGroupAndReturnAdId(nonTextCampaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8637")
    public void updateBannerTagsOfNonTextCampaign(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId,type);
        api.as(anotherClient).userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                new BannerTagsInfo[]{
                        (BannerTagsInfo)new BannerTagsInfoMap(api.type())
                        .withBannerID(nonTextBannerId)
                        .withTags(nonTextTagsIDS).getBean()},
                new AxisError(54, AxisErrorDetails.CAMPAIGNID_NOT_FOUND));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8638")
    public void reUpdateBannerTagsOfNonTextCampaign(){
        log.info("Привязываем тэг к баннеру.");
        api.userSteps.tagSteps().updateBannerTags(nonTextBannerId, nonTextTagsIDS[0]);
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
        log.info("Редактируем привязанный тэг к баннеру.");
        api.as(anotherClient).userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                new BannerTagsInfo[]{
                        (BannerTagsInfo)new BannerTagsInfoMap(api.type())
                        .withBannerID(nonTextBannerId)
                        .withTags(nonTextTagsIDS).getBean()},
                new AxisError(54, AxisErrorDetails.CAMPAIGNID_NOT_FOUND));
    }
}
