package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class UpdateBannersTagsForNonTextCampaignTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static int nonTextTagsID;
    private static Long nonTextBannerId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.DYNAMIC},
                {CampaignsType.TEXT},
                {CampaignsType.MCBANNER},
                {CampaignsType.PERFORMANCE}
        });
    }

    @Before
    public void createNonTextCampaigns(){
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        nonTextTagsID = api.userSteps.tagSteps().addTags(nonTextCampaignId, TAG_FOR_MOBILE)[0];
        nonTextBannerId = api.userSteps.addCompletedAdGroupAndReturnAdId(nonTextCampaignId);
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId,type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8639")
    public void updateBannerTagsOfNonTextCampaign(){
        api.userSteps.tagSteps().updateBannerTags(nonTextBannerId, nonTextTagsID);
        BannerTagsInfo[] getResponse = api.userSteps.tagSteps().getBannersTags(new BannersRequestInfoMap(api.type())
                .withBannerIDS(nonTextBannerId));
        assertThat("вернулась одна метка", getResponse, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(nonTextBannerId)
                        .withTags(nonTextTagsID).getBean()}));
    }
}
