package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
@Description("Обновить метки баннеров для невалидных " + BannerTagsInfoMap.BANNER_ID)
public class UpdateBannersTagsInvalidBannerIDTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long invalidBannerID;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long deletedBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.adsSteps().adsDelete(deletedBannerID);
        Long nonexistentBannerID = deletedBannerID + 999999L;

        return Arrays.asList(new Object[][]{
                {"Нулевое значение", 0l},
                {"Отрицательное значение", -1l},
                {"Удалённая кампания", deletedBannerID},
                {"Несуществующая кампания", nonexistentBannerID},
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8640")
    public void invalidBannerID() {
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                Arrays.asList(new BannerTagsInfoMap(api.type())
                        .withBannerID(invalidBannerID)
                        .withTags(new int[]{}).getBean()),
                new AxisError(71, AxisErrorDetails.BANNER_NOT_FOUND, invalidBannerID));
    }
}
