package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метки баннеров с невалидными " + BannerTagsInfoMap.TAG_IDS)
public class UpdateBannersTagsInvalidTagIDTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long bannerID;

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public int invalidTagID;

    @Parameterized.Parameter(value = 2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"нулевое значение", 0, new AxisError(71, AxisErrorDetails.TAGS_NOT_INCLUDED_IN_THE_CAMPAIGN_TAG_LIST)},
                {"отрицательное значение", -1,
                        new AxisError(71, AxisErrorDetails.ARRAY_SHOULD_CONTAIN_UNSIGNED_INTEGER_VALUE,
                                capitalize(BannerTagsInfoMap.TAG_IDS))},
                {"метка не принадлежащая кампании", 1,
                        new AxisError(71, AxisErrorDetails.TAGS_NOT_INCLUDED_IN_THE_CAMPAIGN_TAG_LIST)}
        });
    }

    @BeforeClass
    public static void createBanner() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8641")
    public void invalidTagID() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                Arrays.asList(new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(invalidTagID).getBean()),
                expectedError);
    }
}
