package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метки баннеров: валидация JSON")
public class UpdateBannersTagsJsonValidationTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long bannerID;
    private static int tagID;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, "Tag");
        assumeThat("добавилась одна метка для кампании", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];

        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Не массив в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8644")
    public void notAnArrayInRequest() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannerTagsInfoMap.BANNER_ID), bannerID);
        request.put(capitalize(BannerTagsInfoMap.TAG_IDS), new int[]{tagID});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                request,
                new AxisError(9, AxisErrorDetails.THE_BANNERLIST_FIELD_MUST_BE_AN_ARRAY));
    }

    @Test
    @Title("Массив в поле " + BannerTagsInfoMap.BANNER_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8642")
    public void anArrayInBannerIdField() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannerTagsInfoMap.BANNER_ID), new Long[]{bannerID});
        request.put(capitalize(BannerTagsInfoMap.TAG_IDS), new int[]{tagID});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.FIELD_SHOULD_HAVE_AN_INTEGER_VALUE,
                        capitalize(BannerTagsInfoMap.BANNER_ID)));
    }

    @Test
    @Title("Не массив в поле " + BannerTagsInfoMap.TAG_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8643")
    public void notAnArrayInTagIdsField() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannerTagsInfoMap.BANNER_ID), bannerID);
        request.put(capitalize(BannerTagsInfoMap.TAG_IDS), tagID);

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                new Object[]{request},
                new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY, capitalize(BannerTagsInfoMap.TAG_IDS)));
    }

    @Test
    @Title("Значение типа массива внутри массива поля " + BannerTagsInfoMap.TAG_IDS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8645")
    public void anArrayInTagIdsArray() {
        JSONObject request = new JSONObject();
        request.put(capitalize(BannerTagsInfoMap.BANNER_ID), bannerID);
        request.put(capitalize(BannerTagsInfoMap.TAG_IDS), new int[][]{new int[]{tagID}});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.ARRAY_SHOULD_CONTAIN_UNSIGNED_INTEGER_VALUE,
                        capitalize(BannerTagsInfoMap.TAG_IDS)));
    }

}
