package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import java.util.Arrays;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.BUG)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
@Description("Создать метки баннеров: обязательные поля")
public class UpdateBannersTagsMandatoryFieldsTestFailed {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long bannerID;
    private static int tagID;

    @BeforeClass
    public static void createCampaign() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, "TAG");
        assumeThat("для кампании добавилась одна метка", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];

        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
//    @Title("Вызов метода без поля " + BannerTagsInfoMap.TAG_IDS)
    @Title("DIRECT-36824")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8646")
    public void requestWithoutTagIDS() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                Arrays.asList(new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(null).getBean()),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, capitalize(BannerTagsInfoMap.TAG_IDS)));
    }

    @Test
//    @Title("Вызов метода без поля " + BannerTagsInfoMap.BANNER_ID)
    @Title("DIRECT-36825")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8647")
    public void requestWithoutBannerID() {
        JSONObject request = new JSONObject();
        request.put(BannerTagsInfoMap.TAG_IDS, new int[]{tagID});
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.BANNER_NOT_FOUND, ""));
    }
}
