package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метку баннера через протокол SOAP")
public class UpdateBannersTagsSOAPTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private int tagID;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.protocol(ProtocolType.JSON);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, "Tag");
        assumeThat("в кампанию добавилась одна метки", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Запрос через SOAP")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8648")
    public void soapTest() {
        api.protocol(ProtocolType.SOAP);
        api.userSteps.tagSteps().updateBannerTags(bannerID, tagID);
        api.protocol(ProtocolType.JSON);
        BannerTagsInfo[] response = api.userSteps.tagSteps().getBannersTags(new BannersRequestInfoMap(api.type())
                .withBannerIDS(bannerID));
        assertThat("результат соответствует ожидаемому", response, beanDiffer(new Object[]{
                new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(tagID).getBean()}));
    }
}
