package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.BannerTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.BannersRequestInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayContainingInAnyOrder;
import static org.hamcrest.Matchers.emptyArray;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/17/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метки баннера для одинаковых идентификаторов баннеров")
public class UpdateBannersTagsSameBannerIDsTest {

    private static final String TAG_1 = "Tag1";
    private static final String TAG_2 = "Tag2";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private Integer firstTagID;
    private Integer secondTagID;

    @Before
    @Title("Подготовка данных для теста")
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, TAG_1, TAG_2);
        assumeThat("добавилось два тега кампании", tagIDS.length, equalTo(2));
        firstTagID = tagIDS[0];
        secondTagID = tagIDS[1];
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Два одинаковых идентификатора баннера")
//    @Title("DIRECT-36827")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8649")
    public void twoSameBannerIDs() {
        api.userSteps.tagSteps().updateBannersTags(
                new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(firstTagID),
                new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(secondTagID));

        BannerTagsInfo[] getResponse = api.userSteps.tagSteps().getBannersTags(new BannersRequestInfoMap(api.type())
                .withBannerIDS(bannerID));
        assumeThat("вернулся не пустой ответ", getResponse, not(emptyArray()));
        Integer[] tagIDs = ArrayUtils.toObject(getResponse[0].getTagIDS());

        assertThat("вернулись две метки", tagIDs, arrayContainingInAnyOrder(firstTagID, secondTagID));
    }
}
