package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/17/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.TAGS)
@Description("Добавить метки баннера: число меток больше максимального")
public class UpdateBannersTagsTagIDsLengthRestrictionNegativeTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private int[] tagIDS;

    @Before
    @Title("Подготовка данных для теста")
    public void createCampaign() {
        String[] tags = new String[BannerTagsInfoMap.MAX_TAG_IDS_LENGTH + 1];
        for (int i = 0; i < tags.length; i++) {
            tags[i] = "Tag" + (i + 1);
        }
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        tagIDS = api.userSteps.tagSteps().addTags(campaignId, tags);
        assumeThat("создалось " + tags.length + " меток для кампании",
                tagIDS.length, equalTo(tags.length));
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Число меток на единицу больше максимального")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8651")
    public void maxBannerTagsLengthPlusOne() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_BANNERS_TAGS,
                Arrays.asList(new BannerTagsInfoMap(api.type())
                        .withBannerID(bannerID)
                        .withTags(tagIDS).getBean()),
                new AxisError(71, AxisErrorDetails.TAGS_LIMIT_FOR_BANNER_EXCEEDED));
    }
}

