package ru.yandex.autotests.directapi.banners.tags.updatebannerstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.BannerTagsInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/17/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.TAGS)
@Description("Добавить метки баннера: максимальное число меток баннера")
public class UpdateBannersTagsTagIDsLengthRestrictionTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private int[] tagIDS;

    @Before
    @Title("Подготовка данных для теста")
    public void createCampaign() {
        String[] tags = new String[BannerTagsInfoMap.MAX_TAG_IDS_LENGTH];
        for (int i = 0; i < BannerTagsInfoMap.MAX_TAG_IDS_LENGTH; i++) {
            tags[i] = "Tag" + (i + 1);
        }
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        tagIDS = api.userSteps.tagSteps().addTags(campaignId, tags);
        assumeThat("создалось " + BannerTagsInfoMap.MAX_TAG_IDS_LENGTH + " меток для кампании",
                tagIDS.length, equalTo(BannerTagsInfoMap.MAX_TAG_IDS_LENGTH));
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @Title("Максимальное число меток")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8652")
    public void maxTagIDsLength() {
        int response = api.userSteps.tagSteps().updateBannersTags(new BannerTagsInfoMap(api.type())
                .withBannerID(bannerID)
                .withTags(tagIDS));
        assertThat("метод отработал успешно", response, equalTo(1));
    }
}
