package ru.yandex.autotests.directapi.banners.tags.updatebannerstags.roles;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/17/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.UPDATE_BANNERS_TAGS)
@Tag(TagDictionary.TRUNK)
@Stories(ApiStories.TAGS)
@Description("Создать метки баннера: позитивный сценарий для внутренних ролей")
public class UpdateBannersTagsInternalRolesRightsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private int tagID;

    @Parameterized.Parameter(value = 0)
    public String login;

    @Parameterized.Parameters(name = "Логин пользователя: {0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {Logins.PLACER},
                {Logins.SUPPORT},
                {Logins.SUPER_LOGIN}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(BannerLogins.CLIENT_SELF);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, "TAG");
        assumeThat("создалась одна метка для кампании", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];
        bannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8656")
    public void checkUpdateCampaignsTagsResponse() {
        api.as(login);
        int response = api.userSteps.tagSteps().updateBannerTags(bannerID, tagID);
        assertThat("метод отработал успешно", response, equalTo(1));
    }
}
