package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/12/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метки для двух кампаний")
public class UpdateCampaignsTagsCreateForTwoCampaignsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long firstCampaignID;
    private Long secondCampaignID;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        firstCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        secondCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Title("По одной метке для двух кампаний")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8658")
    public void oneTagForEveryOfTwoCampaigns() {
        CampaignTagsInfoMap firstCampaignTagsInfoMap = new CampaignTagsInfoMap(api.type())
                .withCampaignID(firstCampaignID.intValue())
                .withTags(new TagInfoMap(api.type())
                        .withTagID(0)
                        .withTag("Tag"));
        CampaignTagsInfoMap secondCampaignTagsInfoMap = new CampaignTagsInfoMap(api.type())
                .withCampaignID(secondCampaignID.intValue())
                .withTags(new TagInfoMap(api.type())
                        .withTagID(0)
                        .withTag("Tag"));
        CampaignTagsInfo[] response = sort(api.userSteps.tagSteps().updateCampaignsTags(
                firstCampaignTagsInfoMap, secondCampaignTagsInfoMap),
                on(CampaignTagsInfo.class).getCampaignID()).toArray(new CampaignTagsInfo[0]);

        MatchVariation variation = new DefaultMatchVariation() // TODO fields path
                .forFields("[0]/tags[0]/tagID", "[1]/tags[0]/tagID").useMatcher(greaterThan(0));
        assertThat("результат соответствует ожидаемому", response, beanDiffer(new Object[]{
                firstCampaignTagsInfoMap.getBean(), secondCampaignTagsInfoMap.getBean()}).withVariation(variation));
    }
}
