package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 05.08.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class UpdateCampaignsTagsForNonTextCampaignNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static final String TAG_FOR_TEXT = "tagForTextCamp";

    @Rule
    public Trashman trasher = new Trashman(api);
    private CampaignTagsInfo[] campaignTags;
    private CampaignTagsInfo[] campaignTagsInfos;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB}
        });
    }

    @Before
    public void createNonTextAndTextCampaigns(){
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId,type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8661")
    public void createCampaignTagsForNonTextTest(){
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new CampaignTagsInfo[]{(CampaignTagsInfo)new CampaignTagsInfoMap(api.type())
                        .withCampaignID(nonTextCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(0)
                                        .withTag(TAG_FOR_MOBILE)).getBean()},
                new AxisError(3500));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8662")
    public void createCampaignTagsForTextAndNonTextTest(){
        campaignTags = api.userSteps.tagSteps().updateCampaignsTags(
                );
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new CampaignTagsInfo[]{ (CampaignTagsInfo)
                        new CampaignTagsInfoMap(api.type())
                                .withCampaignID(nonTextCampaignId.intValue())
                                .withTags(
                                        new TagInfoMap(api.type())
                                                .withTagID(0)
                                                .withTag(TAG_FOR_MOBILE)).getBean(),
                        (CampaignTagsInfo)
                        new CampaignTagsInfoMap(api.type())
                                .withCampaignID(textCampaignId.intValue())
                                .withTags(
                                        new TagInfoMap(api.type())
                                                .withTagID(0)
                                                .withTag(TAG_FOR_TEXT)).getBean()
                },
                new AxisError(3500));
    }
}
