package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining.hasItems;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class UpdateCampaignsTagsForNonTextCampaignTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static final String TAG_FOR_MOBILE = "tagForMobileCamp";
    private static final String TAG_FOR_TEXT = "tagForTextCamp";

    @Rule
    public Trashman trasher = new Trashman(api);
    private CampaignTagsInfo[] campaignTags;
    private CampaignTagsInfo[] campaignTagsInfos;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.DYNAMIC},
                {CampaignsType.TEXT},
                {CampaignsType.MCBANNER},
                {CampaignsType.PERFORMANCE},
                {CampaignsType.CPM_BANNER},
        });
    }

    @Before
    public void createNonTextAndTextCampaigns(){
        nonTextCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId,type);
    }
    
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8666")
    public void createCampaignTagsForNonTextTest(){
        campaignTags = api.userSteps.tagSteps().updateCampaignsTags(
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(nonTextCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(0)
                                        .withTag(TAG_FOR_MOBILE)));
        assumeThat("метка создалась", campaignTags.length, equalTo(1));
        campaignTagsInfos = api.userSteps.tagSteps().getCampaignsTags(nonTextCampaignId);
        assertThat("результат соответствует ожидаемому", campaignTagsInfos, beanDiffer(new Object[]{
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(nonTextCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(campaignTags[0].getTags()[0].getTagID())
                                        .withTag(TAG_FOR_MOBILE)).getBean()}));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8667")
    public void createCampaignTagsForTextAndNonTextTest(){
        campaignTags = api.userSteps.tagSteps().updateCampaignsTags(
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(nonTextCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(0)
                                        .withTag(TAG_FOR_MOBILE)),
                new CampaignTagsInfoMap(api.type())
                        .withCampaignID(textCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(0)
                                        .withTag(TAG_FOR_TEXT)));
        assumeThat("метка создалась", campaignTags.length, equalTo(2));
        campaignTagsInfos = api.userSteps.tagSteps().getCampaignsTags(nonTextCampaignId, textCampaignId);
        assertThat("результат соответствует ожидаемому", campaignTagsInfos, hasItems(
                beanEquals(
                (CampaignTagsInfo)new CampaignTagsInfoMap(api.type())
                        .withCampaignID(textCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTag(TAG_FOR_TEXT)).getBean()),
                beanEquals(
                (CampaignTagsInfo)new CampaignTagsInfoMap(api.type())
                        .withCampaignID(nonTextCampaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTag(TAG_FOR_MOBILE)).getBean()).ignoreFields(TagInfoMap.TAG_ID)));
    }

}
