package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Обновить метки кампаний для невалидных идетификаторов кампаний")
public class UpdateCampaignsTagsInvalidCampaignIDTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public Long invalidCampaignID;

    @Parameterized.Parameter(value = 2)
    public AxisError expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        Long deletedCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsDelete(deletedCampaignID);
        Long nonexistentCampaignID = deletedCampaignID + 999999;
        return Arrays.asList(new Object[][]{
                {"Нулевое значение", 0L, new AxisError(1)},
                {"Отрицательное значение", -1L, new AxisError(1)},
                {"Удалённая кампания", deletedCampaignID, new AxisError(1)},
                {"Несуществующая кампания", nonexistentCampaignID, new AxisError(1)},
        });
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8668")
    public void invalidCampaignID() {
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(invalidCampaignID.intValue())
                        .withTags(new TagInfoMap[]{}).getBean()),
                expectedError);
    }
}
