package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Обновить метки кампаний: валидация JSON")
public class UpdateCampaignsTagsJsonValidationTest {

    private static final String SOME_STRING = "someString";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Title("Не массив в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8670")
    public void notAnArrayInRequest() {
        JSONObject tag = new JSONObject();
        tag.put(capitalize(TagInfoMap.TAG_ID), 0);
        tag.put(capitalize(TagInfoMap.TAG), SOME_STRING);

        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), campaignId);
        request.put(capitalize(CampaignTagsInfoMap.TAGS), new Object[]{tag});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                request,
                new AxisError(501));
    }

    @Test
    @Title("Массив в поле " + CampaignTagsInfoMap.CAMPAIGN_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8671")
    public void anArrayInCampaignIdField() {
        JSONObject tag = new JSONObject();
        tag.put(capitalize(TagInfoMap.TAG_ID), 0);
        tag.put(capitalize(TagInfoMap.TAG), SOME_STRING);

        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), new long[]{campaignId});
        request.put(capitalize(CampaignTagsInfoMap.TAGS), new Object[]{tag});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new Object[]{request},
                new AxisError(1));
    }

    @Test
    @Title("Не массив в поле " + CampaignTagsInfoMap.TAGS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8672")
    public void notAnArrayInTagsField() {
        JSONObject tag = new JSONObject();
        tag.put(capitalize(TagInfoMap.TAG_ID), 0);
        tag.put(capitalize(TagInfoMap.TAG), SOME_STRING);

        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), campaignId);
        request.put(capitalize(CampaignTagsInfoMap.TAGS), tag);

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new Object[]{request},
                new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY,
                        capitalize(CampaignTagsInfoMap.TAGS)));
    }

    @Test
    @Title("Массив в поле " + TagInfoMap.TAG_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8673")
    public void anArrayInTagIdField() {
        JSONObject tag = new JSONObject();
        tag.put(capitalize(TagInfoMap.TAG_ID), new int[]{0});
        tag.put(capitalize(TagInfoMap.TAG), SOME_STRING);

        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), campaignId);
        request.put(capitalize(CampaignTagsInfoMap.TAGS), new Object[]{tag});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
                        capitalize(TagInfoMap.TAG_ID)));
    }

    @Test
    @Title("Массив в поле " + TagInfoMap.TAG)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8674")
    public void anArrayInTagField() {
        JSONObject tag = new JSONObject();
        tag.put(capitalize(TagInfoMap.TAG_ID), 0);
        tag.put(capitalize(TagInfoMap.TAG), new String[]{SOME_STRING});

        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), campaignId);
        request.put(capitalize(CampaignTagsInfoMap.TAGS), new Object[]{tag});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.FIELD_MUST_BE_STRING,
                        capitalize(TagInfoMap.TAG)));
    }

    @Test
    @Title("Строка в массиве " + CampaignTagsInfoMap.TAGS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8675")
    public void stringInTagsArray() {
        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), campaignId);
        request.put(capitalize(CampaignTagsInfoMap.TAGS), new Object[]{SOME_STRING});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.FIELD_SHOULD_BE_A_STRUCTURE_ARRAY,
                        capitalize(CampaignTagsInfoMap.TAGS)));
    }
}
