package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Обновить метки кампаний: обязательные поля")
public class UpdateCampaignsTagsMandatoryFieldsTest {

    private static final String TAG = "Tag";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static int tagID;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, TAG);
        assumeThat("в кампанию добавилась одна метка", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];
    }

    @Test
    @Title("Запрос без " + CampaignTagsInfoMap.CAMPAIGN_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8676")
    public void updateCampaignsTagsWithoutCampaignID() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withTags(new TagInfoMap(api.type())
                                .withTagID(tagID)
                                .withTag(TAG)).getBean()),
                new AxisError(1));
    }

    @Test
    @Title("Запрос без " + CampaignTagsInfoMap.TAGS)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8677")
    public void updateCampaignsTagsWithoutTagsField() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue()).getBean()),
                new AxisError(9, AxisErrorDetails.THE_FIELD_MUST_BE_AN_ARRAY, capitalize(CampaignTagsInfoMap.TAGS)));
    }

    @Test
    @Title("Запрос без " + TagInfoMap.TAG)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8678")
    public void updateCampaignsTagsWithoutTagField() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withTags(new TagInfoMap(api.type())
                                .withTagID(tagID)).getBean()),
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, capitalize(TagInfoMap.TAG)));
    }

    @Test
    @Title("Запрос без " + TagInfoMap.TAG_ID)
    @ru.yandex.qatools.allure.annotations.TestCaseId("8679")
    public void updateCampaignsTagsWithoutTagIdField() {
        JSONObject tags = new JSONObject();
        tags.put(capitalize(TagInfoMap.TAG), TAG);
        JSONObject request = new JSONObject();
        request.put(capitalize(CampaignTagsInfoMap.CAMPAIGN_ID), campaignId);
        request.put(capitalize(CampaignTagsInfoMap.TAGS), new Object[]{tags});

        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                new Object[]{request},
                new AxisError(71, AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY, capitalize(TagInfoMap.TAG_ID)));
    }
}
