package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метки кампании через SOAP")
public class UpdateCampaignsTagsSOAPTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.protocol(ProtocolType.JSON);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Title("Создать метку через SOAP")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8680")
    public void soapTest() {
        api.protocol(ProtocolType.SOAP);
        CampaignTagsInfoMap requestMap = new CampaignTagsInfoMap(api.type())
                .withCampaignID(campaignId.intValue())
                .withTags(new TagInfoMap(api.type())
                        .withTagID(0)
                        .withTag("Tag"));

        CampaignTagsInfo[] response = api.userSteps.tagSteps().updateCampaignsTags(requestMap);
        MatchVariation variation = new DefaultMatchVariation() // TODO Fix field path
                .forFields("[0]/tags[0]/tagID").useMatcher(greaterThan(0));
        assertThat("результат соответствует ожидаемому", response, beanDiffer(new Object[]{
                requestMap.getBean()}).withVariation(variation));
    }
}
