package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.DefaultMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/17/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.BUG)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
@Description("Создать метки кампании для одинаковых идентификаторов кампании")
public class UpdateCampaignsTagsSameCampaignIDsTest {

    private static final String TAG_1 = "Tag1";
    private static final String TAG_2 = "Tag2";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    @Title("Подготовка данных для теста")
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
//    @Title("Два одинаковых идентификатора кампании")
    @Title("DIRECT-36827")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8681")
    public void twoSameCampaignIDs() {
        CampaignTagsInfoMap firstCampaignTagsInfoMap = new CampaignTagsInfoMap(api.type())
                .withCampaignID(campaignId.intValue())
                .withTags(new TagInfoMap(api.type())
                        .withTagID(0)
                        .withTag(TAG_1));
        CampaignTagsInfoMap secondCampaignTagsInfoMap = new CampaignTagsInfoMap(api.type())
                .withCampaignID(campaignId.intValue())
                .withTags(new TagInfoMap(api.type())
                        .withTagID(0)
                        .withTag(TAG_2));

        CampaignTagsInfo[] response = api.userSteps.tagSteps().updateCampaignsTags(
                firstCampaignTagsInfoMap, secondCampaignTagsInfoMap);

        MatchVariation variation = new DefaultMatchVariation() // TODO Fix fields path
                .forFields("[0]/tags[0]/tagID").useMatcher(greaterThan(0));
        assertThat("вернулась одна метка", response, beanDiffer(new Object[]{
                secondCampaignTagsInfoMap.getBean()}).withVariation(variation));
    }
}
