package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Обновить метки кампании для двух одинаковых идентификаторов меток")
public class UpdateCampaignsTagsSameTagIDsTest {

    private static final String TAG = "Tag";
    private static final String TAG_1 = "Tag1";
    private static final String TAG_2 = "Tag2";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private int tagID;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, TAG);
        assumeThat("добавилась одна метка", tagIDS.length, equalTo(1));
        tagID = tagIDS[0];
    }

    @Test
    @Title("Два одинаковых идетификаторов метки")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8682")
    public void twoSameTagIDs() {
        //DIRECT-36779
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(tagID)
                                        .withTag(TAG_1),
                                new TagInfoMap(api.type())
                                        .withTagID(tagID)
                                        .withTag(TAG_2)).getBean()),
                new AxisError(71, AxisErrorDetails.IN_CAMPAIGN_TAGS_LIST_DUPLICATED_TAGS, campaignId, tagID));
    }
}
