package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
@Description("Создать метки с одинаковым текстом для кампании")
public class UpdateCampaignsTagsSameTagsTest {

    private static final String TAG = "Tag";

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public String tag1;

    @Parameterized.Parameter(value = 2)
    public String tag2;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"Две одинаковые метки", TAG, TAG},
                {"Две метки с одинаковым текстом, но с разным регистром", TAG.toLowerCase(), TAG.toUpperCase()}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8683")
    public void twoSameTags() {
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withTags(
                                new TagInfoMap(api.type())
                                        .withTagID(0)
                                        .withTag(tag1),
                                new TagInfoMap(api.type())
                                        .withTagID(0)
                                        .withTag(tag2)).getBean()),
                new AxisError(71, AxisErrorDetails.THIS_TAG_IS_ALREADY_BEING_USED));
    }
}
