package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import java.util.Arrays;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 11/14/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.BUG)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Tag(TagDictionary.BUG)
@Description("Создать меткти, число которых больше максимального")
public class UpdateCampaignsTagsTagsLengthRestrictionNegativeTestFailed {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
//    @Title("Число меток на единицу больше максимального")
    @Title("DIRECT-36709")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8686")
    public void maxTagsArrayLengthPlusOne() {
        TagInfoMap[] tagInfoMaps = createTagInfoMaps(CampaignTagsInfoMap.MAX_TAGS_LENGTH + 1);
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withTags(tagInfoMaps).getBean()),
                new AxisError(71, AxisErrorDetails.TAGS_NUMBER_EXCEEDED));
    }

    private static TagInfoMap[] createTagInfoMaps(int amount) {
        TagInfoMap[] tagInfoMaps = new TagInfoMap[amount];
        for (int i = 0; i < amount; i++) {
            tagInfoMaps[i] = new TagInfoMap(api.type())
                    .withTagID(0)
                    .withTag("Tag" + (i + 1));
        }
        return tagInfoMaps;
    }
}
