package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45.CampaignTagsInfo;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by semkagtn on 11/12/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Изменить метки для кампании")
public class UpdateCampaignsTagsUpdateTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(BannerLogins.CLIENT_SELF);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private int firstTagID;
    private int secondTagID;

    private static final String TAG_1 = "Tag1";
    private static final String TAG_2 = "Tag2";
    private static final String NEW_TAG = "NewTag";

    @Before
    @Step("Подготовка данных для теста")
    public void crateCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int[] tagIDS = api.userSteps.tagSteps().addTags(campaignId, TAG_1, TAG_2);
        firstTagID = tagIDS[0];
        secondTagID = tagIDS[1];
    }

    @Test
    @Title("Изменить одну метку из двух")
    @ru.yandex.qatools.allure.annotations.TestCaseId("8688")
    public void updateOneOfTwoTags() {
        CampaignTagsInfoMap updateRequestMap = new CampaignTagsInfoMap(api.type())
                .withCampaignID(campaignId.intValue())
                .withTags(
                        new TagInfoMap(api.type())
                                .withTagID(firstTagID)
                                .withTag(NEW_TAG),
                        new TagInfoMap(api.type())
                                .withTagID(secondTagID)
                                .withTag(TAG_2));
        CampaignTagsInfo[] updateResponse = api.userSteps.tagSteps().updateCampaignsTags(updateRequestMap);
        assertThat("одна метка изменена", updateResponse, beanDiffer(new Object[]{
                updateRequestMap.getBean()}));
    }
}
