package ru.yandex.autotests.directapi.banners.tags.updatecampaignstags.roles;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.banners.BannerFeatures;
import ru.yandex.autotests.directapi.banners.BannerLogins;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.banners.tags.CampaignTagsInfoMap;
import ru.yandex.autotests.directapi.model.banners.tags.TagInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by semkagtn on 11/13/14.
 * https://st.yandex-team.ru/TESTIRT-3320
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(BannerFeatures.UPDATE_CAMPAIGNS_TAGS)
@Stories(ApiStories.TAGS)
@Tag(TagDictionary.TRUNK)
@Description("Создать метки кампании: негативный сценарий для внешних ролей")
public class UpdateCampaignsTagsExternalRolesRightsNegativeTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String apiUserLogin;

    @Parameterized.Parameter(value = 1)
    public String createCampaignLogin;

    @Parameterized.Parameter(value = 2)
    public String campaignOwnerLogin;

    private Long campaignId;

    @Parameterized.Parameters(name = "Вызов метода от: {0}, владелец кампании: {2}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {BannerLogins.AGENCY_SHARD_2, BannerLogins.AGENCY, BannerLogins.SUB_CLIENT_DEFAULT},
                {BannerLogins.MANAGER_DEFAULT, BannerLogins.SUPER_LOGIN, BannerLogins.CLIENT_SELF2},
                {BannerLogins.CLIENT_SELF_REP, BannerLogins.SUPER_LOGIN, BannerLogins.CLIENT_FOR_RUB},
                {BannerLogins.CLIENT_SELF, BannerLogins.SUPER_LOGIN, BannerLogins.CLIENT_SELF2},
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        api.as(createCampaignLogin);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(campaignOwnerLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("8689")
    public void checkUpdateCampaignsTagsResponse() {
        api.as(apiUserLogin);
        api.userSteps.shouldGetErrorOn(
                Method.UPDATE_CAMPAIGNS_TAGS,
                Arrays.asList(new CampaignTagsInfoMap(api.type())
                        .withCampaignID(campaignId.intValue())
                        .withTags(new TagInfoMap(api.type())
                                .withTagID(0)
                                .withTag("Tag")).getBean()),
                new AxisError(54, AxisErrorDetails.FIELD_NOT_FOUND, capitalize(CampaignTagsInfoMap.CAMPAIGN_ID)));
    }
}
