package ru.yandex.autotests.directapi.campaigns.getbalance;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(CampaignFeatures.GET_BALANCE)
@RunWith(Parameterized.class)
public class MethodAvailabilityTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public int apiVersion;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection apiVersions() {
        Object[][] data = new Object[][] {
                {5},
                {104},
                {4}
        };
        return Arrays.asList(data);
    }

    @Test
    public void methodNotAvailableTest() {
        api.version(apiVersion).userSteps.financeSteps().shouldGetErrorOn(Method.GET_BALANCE, 123,
                new AxisError(509));
    }
}
