package ru.yandex.autotests.directapi.campaigns.geteventslog;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 11.03.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1595
 */
@Aqua.Test
@Features(CampaignFeatures.ADD_EVENTS)
@Stories(ApiStories.SHARDING)
public class AddEventsShardingTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientShard2 = CampaignLogins.SELF_CLIENT_SHARD_2;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void prepareCampaign(){
        api.userSteps.clientFakeSteps().reshardUserWithLock(clientShard2, ShardNumbers.EXTRA_SHARD);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(clientShard2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5505")
    public void addEventForClientInShard2() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap event = new EventsLogItemMap(api.type())
                .moneyInEvent(campaignId.intValue(), 15f, Currency.RUB.toString());
        api.userSteps.eventLogFakeSteps().addEvents(event);

        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withLogins(clientShard2)
                        .withCurrency(CLIENT_CURRENCY)
        );
        assertThat("вернулся некоторый набор событий", events.length, greaterThan(0));
    }
}
