package ru.yandex.autotests.directapi.campaigns.geteventslog;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.BannerPhraseInfo;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.everyItem;
import static org.hamcrest.Matchers.greaterThan;

/**
 * Created with IntelliJ IDEA.
 * User: pavryabov
 * Date: 19.02.14
 * Time: 19:55
 * https://jira.yandex-team.ru/browse/DIRECT-28424
 */
@Aqua.Test
@Features(CampaignFeatures.NOT_REGRESSION_YET)
@Stories(ApiStories.AVAILABLE_INT)
public class GetEventsLogAvailableIntTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CampaignLogins.SELF_CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long bannerID;
    private String timestampBefore;

    @Before
    public void initTest() {
        api.version(104);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerID = api.userSteps.bannerSteps().createDefaultBanner(campaignId);
        BannerPhraseInfo phrase = (BannerPhraseInfo) api.userSteps.bannerSteps().getBannerPhrases(bannerID)[0];
        timestampBefore = api.userSteps.getChangesSteps().getTimestamp();
        api.userSteps.eventLogFakeSteps().addEvents(
                new EventsLogItemMap(api.type()).lowCtrEvent(new BannerPhraseInfoMap(phrase)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5508")
    public void availableLongIn2VersionTest() {
        api.version(2);
        ru.yandex.autotests.directapi.common.api45f.EventsLogItem[] events =
                api.userSteps.soapClient().invokeMethod(Method.GET_EVENTS_LOG,
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestampBefore)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                        .withCampaignIDS(campaignId.intValue()))

                                .getBean()
                );
        assertThat(
                extract(events,
                        on(ru.yandex.autotests.directapi.common.api45f.EventsLogItem.class).getPhraseID()),
                everyItem(greaterThan(0L))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5509")
    public void availableLongIn104VersionTest() {
        api.version(104);
        ru.yandex.autotests.directapi.common.api45.EventsLogItem[] events =
                api.userSteps.soapClient().invokeMethod(Method.GET_EVENTS_LOG,
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestampBefore)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                        .withCampaignIDS(campaignId.intValue()))

                                .getBean()
                );
        assertThat(
                extract(events,
                        on(ru.yandex.autotests.directapi.common.api45.EventsLogItem.class).getPhraseID()),
                everyItem(greaterThan(0L))
        );
    }
}
