package ru.yandex.autotests.directapi.campaigns.geteventslog;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.BannerModerationResult;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static ru.yandex.autotests.directapi.matchers.arrays.ArraySizeMatcher.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями для чужого логина.")
@RunWith(Parameterized.class)
public class GetEventsLogForNonTextCampaignRightsTest {

    private static final String ANOTHER_CLIENT = Logins.CLIENT_DOT_LOGIN;
    private static final String CLIENT = CampaignLogins.CLIENT_FREE_YE_DEFAULT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static String timestamp;
    private static Long nonTextBannerID;
    private static Long textBannerID;
    private static EventsLogItemMap nonTextEvent;
    private static EventsLogItemMap textEvent;
    private EventsLogItem[] eventsLog;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE}});
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns(){
        api.as(CLIENT);
        nonTextCampaignId = api.userSteps.addActiveCampaign(CLIENT,1);
        textCampaignId = api.userSteps.addActiveCampaign(CLIENT,1);
        nonTextBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(nonTextCampaignId);
        textBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(textCampaignId);
        timestamp = api.userSteps.changesSteps().getTimestamp();
        nonTextEvent = new EventsLogItemMap(api.type()).bannerModeratedEvent(
                nonTextCampaignId.intValue(), nonTextBannerID, BannerModerationResult.ACCEPTED, Value.YES);
        api.userSteps.eventLogFakeSteps().addEvents(nonTextEvent);
        textEvent = new EventsLogItemMap(api.type()).bannerModeratedEvent(
                textCampaignId.intValue(), textBannerID, BannerModerationResult.ACCEPTED, Value.YES);
        api.userSteps.eventLogFakeSteps().addEvents(textEvent);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5511")
    public void getEventsLogOfNonTextCampaign(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
        eventsLog = api.as(ANOTHER_CLIENT).userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(
                                new GetEventsLogFilterMap(api.type())
                                        .withCampaignIDS(nonTextCampaignId.intValue())
                                        .withBannerIDS(nonTextBannerID))
        );
        assertThat("не вернулись события", eventsLog, hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5512")
    public void getEventsLogOfNonTextAndTextCampaign(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId, type);
        eventsLog = api.as(ANOTHER_CLIENT).userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(
                                new GetEventsLogFilterMap(api.type())
                                        .withCampaignIDS(nonTextCampaignId.intValue(), textCampaignId.intValue())
                                        .withBannerIDS(nonTextBannerID, textBannerID)
                        )
        );
        assertThat("не вернулись события", eventsLog, hasSize(0));
    }
}
