package ru.yandex.autotests.directapi.campaigns.geteventslog;

import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.banners.BannerModerationResult;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraint;
import ru.yandex.autotests.irt.testutils.beandiffer.beanconstraint.BeanConstraints;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 31.07.15.
 * https://st.yandex-team.ru/TESTIRT-6497
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-43114")
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.NON_TEXT_CAMPAIGN)
@Tag(TagDictionary.TRUNK)
@Description("Проверка работы метода с нетекстовыми кампаниями.")
@RunWith(Parameterized.class)
public class GetEventsLogForNonTextCampaignTest {

    private static String client = CampaignLogins.SELF_CLIENT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long nonTextCampaignId;
    private static Long textCampaignId;
    private static String timestamp;
    private static Long nonTextBannerID;
    private static Long textBannerID;
    private static EventsLogItemMap nonTextEvent;
    private static EventsLogItemMap textEvent;

    @Rule
    public Trashman trasher = new Trashman(api);
    private EventsLogItem[] getEventItem;

    @Parameterized.Parameter(value = 0)
    public CampaignsType type;

    @Parameterized.Parameters(name = "Тип кампании: {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignsType.MCB},
                {CampaignsType.MOBILE_CONTENT},
                {CampaignsType.PERFORMANCE}});
    }

    @BeforeClass
    public static void createNonTextAndTextCampaigns(){
        api.version(104).as(client);
        nonTextCampaignId = api.userSteps.addActiveCampaign(client,1);
        textCampaignId = api.userSteps.addActiveCampaign(client,1);
        nonTextBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(nonTextCampaignId);
        textBannerID = api.userSteps.addCompletedAdGroupAndReturnAdId(textCampaignId);
        timestamp = api.userSteps.changesSteps().getTimestamp();
        nonTextEvent = new EventsLogItemMap(api.type()).bannerModeratedEvent(
                nonTextCampaignId.intValue(), nonTextBannerID, BannerModerationResult.ACCEPTED, Value.YES);
        api.userSteps.eventLogFakeSteps().addEvents(nonTextEvent);
        textEvent = new EventsLogItemMap(api.type()).bannerModeratedEvent(
                textCampaignId.intValue(), textBannerID, BannerModerationResult.ACCEPTED, Value.YES);
        api.userSteps.eventLogFakeSteps().addEvents(textEvent);
    }

    @Before
    public void setType(){
        api.userSteps.campaignFakeSteps().setType(nonTextCampaignId,type);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5513")
    public void getEventsLogOfNonTextCampaign(){
        getEventItem = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(
                                new GetEventsLogFilterMap(api.type())
                                    .withCampaignIDS(nonTextCampaignId.intValue())
                                    .withBannerIDS(nonTextBannerID)
                        )
        );
        assumeThat("вернулся 1 объект EventsLogItemAttributes", Arrays.asList(getEventItem), hasSize(1));
        BeanConstraint ignoreFieldConstraint =  new BeanConstraints().ignore(EventsLogItemMap.TIMESTAMP,EventsLogItemMap.EVENT_NAME);
        assertThat("получен предопределенный набор событий", getEventItem,
                IsApiBeanCollectionContaining.hasItems(
                        beanDiffer(nonTextEvent.getBean()).fields(ignoreFieldConstraint)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5514")
    public void getEventsLogOfNonTextAndTextCampaign(){
        getEventItem = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(
                                new GetEventsLogFilterMap(api.type())
                                        .withCampaignIDS(nonTextCampaignId.intValue(), textCampaignId.intValue())
                                        .withBannerIDS(nonTextBannerID, textBannerID)
                        )
        );
        assumeThat("вернулось 2 объекта EventsLogItemAttributes", Arrays.asList(getEventItem), hasSize(2));
        BeanConstraint ignoreFieldConstraint =  new BeanConstraints().ignore(EventsLogItemMap.TIMESTAMP,EventsLogItemMap.EVENT_NAME);
        assertThat("получен предопределенный набор событий", getEventItem,
                IsApiBeanCollectionContaining.hasItems(
                        beanDiffer(nonTextEvent.getBean()).fields(ignoreFieldConstraint),
                        beanDiffer(textEvent.getBean()).fields(ignoreFieldConstraint)));
    }
}
