package ru.yandex.autotests.directapi.campaigns.geteventslog;

import java.util.Arrays;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.banners.BannerModerationResult;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 01.04.15.
 * https://st.yandex-team.ru/TESTIRT-4942
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Issue("https://st.yandex-team.ru/DIRECT-38817")
@Description("Проверка полей Limit и Offset в методе GetEventsLog")
public class PagerTest {

    private static final String CLIENT_LOGIN = CampaignLogins.GET_EVENTS_CLIENT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static EventsLogItemMap bannerEvent1;
    private static EventsLogItemMap bannerEvent2;
    private static EventsLogItemMap bannerEvent3;
    private static EventsLogItemMap bannerEvent4;

    private static String timestampBefore;
    private static String timestampAfter;

    private static Long campaignId;
    private static Long bannerId1;
    private static Long bannerId2;
    private static Long bannerId3;
    private static Long bannerId4;

    @BeforeClass
    public static void prepareEvents() {
        api.userSteps.clientFakeSteps().setAPIUnits(CLIENT_LOGIN, 100000);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        bannerId1 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        bannerId2 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        bannerId3 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        bannerId4 = api.userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(bannerId1, bannerId2, bannerId3, bannerId4);
        timestampBefore = api.userSteps.changesSteps().getTimestamp();
        bannerEvent1 = new EventsLogItemMap(api.type())
                .bannerModeratedEvent(campaignId.intValue(), bannerId1, BannerModerationResult.ACCEPTED, Value.YES);
        bannerEvent2 = new EventsLogItemMap(api.type())
                .bannerModeratedEvent(campaignId.intValue(), bannerId2, BannerModerationResult.ACCEPTED, Value.YES);
        bannerEvent3 = new EventsLogItemMap(api.type())
                .bannerModeratedEvent(campaignId.intValue(), bannerId3, BannerModerationResult.ACCEPTED, Value.YES);
        bannerEvent4 = new EventsLogItemMap(api.type())
                .bannerModeratedEvent(campaignId.intValue(), bannerId4, BannerModerationResult.ACCEPTED, Value.YES);
        api.userSteps.eventLogFakeSteps().addEvents(bannerEvent1, bannerEvent2, bannerEvent3, bannerEvent4);
        timestampAfter = api.userSteps.changesSteps().getTimestamp();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5515")
    public void getHead() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(2)
                        .withOffset(0)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds, equalTo(Arrays.asList(bannerId1, bannerId2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5516")
    public void getBody() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(2)
                        .withOffset(1)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds, equalTo(Arrays.asList(bannerId2, bannerId3)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5525")
    public void getTail() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(2)
                        .withOffset(2)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds, equalTo(Arrays.asList(bannerId3, bannerId4)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5517")
    public void getPartOfTail() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(2)
                        .withOffset(3)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds, equalTo(Arrays.asList(bannerId4)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5518")
    public void getOverTail() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(2)
                        .withOffset(4)
                        .withCurrency(CLIENT_CURRENCY)
        );
        assertThat("вернулся правильный набор событий", Arrays.asList(events), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5519")
    public void onlyLimit() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(2)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds, equalTo(Arrays.asList(bannerId1, bannerId2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5520")
    public void onlyOffset() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withOffset(2)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds,
                equalTo(Arrays.asList(bannerId1, bannerId2, bannerId3, bannerId4)));
    }

    @Issue("https://st.yandex-team.ru/DIRECT-40717")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5521")
    public void zeroLimit() {
        //DIRECT-40717
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.GET_EVENTS_LOG,
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(0)
                        .withCurrency(CLIENT_CURRENCY),
                new AxisError(8, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5522")
    public void negativeLimit() {
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.GET_EVENTS_LOG,
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withLimit(-1)
                        .withCurrency(CLIENT_CURRENCY),
                new AxisError(8, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5523")
    public void zeroOffset() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withOffset(0)
                        .withCurrency(CLIENT_CURRENCY)
        );
        List<Integer> gotBannerIds = extractProperty(events, EventsLogItemMap.BANNER_ID);
        assertThat("вернулся правильный набор событий", gotBannerIds,
                equalTo(Arrays.asList(bannerId1, bannerId2, bannerId3, bannerId4)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5524")
    public void negativeOffset() {
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.GET_EVENTS_LOG,
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withTimestampTo(timestampAfter)
                        .withOffset(-1)
                        .withCurrency(CLIENT_CURRENCY),
                new AxisError(18, AxisErrorDetails.EMPTY_STRING)
        );
    }
}
