package ru.yandex.autotests.directapi.campaigns.geteventslog.account;

import java.util.Arrays;
import java.util.Collection;

import org.hamcrest.Matcher;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventName;
import ru.yandex.autotests.directapi.model.geteventslog.EventType;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItems;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * User: mariabye
 * Date: 31.10.13
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@RunWith(Parameterized.class)
public class GetAccountEventsFilterTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String AGENCY_LOGIN = CampaignLogins.AGENCY_ACCOUNT;
    private static String SUB_CLIENT_1 = CampaignLogins.AGENCY_ACCOUNT_SUB_CLIENT1;
    private static String SUB_CLIENT_2 = CampaignLogins.AGENCY_ACCOUNT_SUB_CLIENT2;
    private static String SUB_CLIENT_NO_ACCOUNT = CampaignLogins.AGENCY_ACCOUNT_SUB_CLIENT_NO_ACCOUNT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    static int accountID1;
    static int accountID2;
    private static String timestamp1;
    private static String timestamp2;
    private static String timestamp3;
    private static Long campaignId;
    private static EventsLogItemMap event1;
    private static EventsLogItemMap event2;
    private static EventsLogItemMap event3;
    private static EventsLogItemMap event4;
    private static EventsLogItemMap event5;

    public static void addEvents() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(AGENCY_LOGIN);

        api.userSteps.financeSteps().verifySharedAccount(SUB_CLIENT_1);
        accountID1 = api.userSteps.financeSteps().getAccountID(SUB_CLIENT_1);

        api.userSteps.financeSteps().verifySharedAccount(SUB_CLIENT_2);
        accountID2 = api.userSteps.financeSteps().getAccountID(SUB_CLIENT_2);

        //создадим промодерированную кампанию, самостоятельно установили имя кампании
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withDefaultTextCampaign().withName("Тестовая кампания API"),
                SUB_CLIENT_NO_ACCOUNT);

        api.clientLogin(SUB_CLIENT_NO_ACCOUNT).userSteps.addCompletedAdGroupAndReturnAdId(campaignId);
        api.userSteps.makeCampaignModerated(campaignId.intValue());

        timestamp1 = api.userSteps.changesSteps().getTimestamp();

        EventsLogItemMap moneyInEvent = new EventsLogItemMap(api.type()).moneyInAccountEvent(accountID1, 10f);
        api.userSteps.eventLogFakeSteps().addEvents(moneyInEvent);
        event1 = new EventsLogItemMap(api.type()).expectedMoneyInAccountEvent(moneyInEvent);

        api.userSteps.changesSteps().getTimestamp();
        moneyInEvent = new EventsLogItemMap(api.type()).moneyInEvent(campaignId.intValue(), 6f);
        api.userSteps.eventLogFakeSteps().addEvents(moneyInEvent);
        event2 = moneyInEvent.withEventName(TextResourceFormatter.resource(EventName.MONEY_IN).toString())
                .withTimestamp(null)
                .withTextDescription("Тестовая кампания API");

        timestamp2 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap moneyWarningEvent = new EventsLogItemMap(api.type()).moneyWarningAccountEvent(accountID1, 5f);
        api.userSteps.eventLogFakeSteps().addEvents(moneyWarningEvent);
        event3 = new EventsLogItemMap(api.type()).expectedMoneyWarningAccountEvent(moneyWarningEvent);

        api.userSteps.changesSteps().getTimestamp();
        moneyWarningEvent = new EventsLogItemMap(api.type()).moneyWarningAccountEvent(accountID2, 4f);
        api.userSteps.eventLogFakeSteps().addEvents(moneyWarningEvent);
        event4 = new EventsLogItemMap(api.type()).expectedMoneyWarningAccountEvent(moneyWarningEvent);

        timestamp3 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap moneyOutEvent = new EventsLogItemMap(api.type()).moneyOutAccountEvent(accountID1);
        api.userSteps.eventLogFakeSteps().addEvents(moneyOutEvent);
        event5 = new EventsLogItemMap(api.type()).expectedMoneyOutAccountEvent(moneyOutEvent);
    }

    @Parameterized.Parameter
    public String description;

    @Parameterized.Parameter(1)
    public GetEventsLogRequestMap filter;

    @Parameterized.Parameter(2)
    public Matcher containsEvents;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection payments() {
        addEvents();
        String[] logins = new String[]{SUB_CLIENT_1, SUB_CLIENT_2, SUB_CLIENT_NO_ACCOUNT};
        Object[][] data = new Object[][]{
                {
                        "Get events for interval time1-time2",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withTimestampTo(timestamp2)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event2.getBean()))
                },
                {
                        "Get events for interval time1-time3",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withTimestampTo(timestamp3)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event2.getBean()),
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean())
                        )
                },
                {
                        "Get events from time1",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event2.getBean()),
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean()),
                                beanEquals((EventsLogItem) event5.getBean())
                        )
                },
                {
                        "Interval with TimestampTo before TimestampFrom",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp2)
                                .withTimestampTo(timestamp1)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        not(hasItems(
                                beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event2.getBean()),
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean()),
                                beanEquals((EventsLogItem) event5.getBean())
                        ))
                },
                {
                        "Get events for interval time2-time3",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp2)
                                .withTimestampTo(timestamp3)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean())
                        )
                },
                {
                        "Get events from time3",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp3)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event5.getBean())
                        )
                },
                {
                        "Filter by accountID1 only",
                        new GetEventsLogRequestMap(api.type())
                                .withFilter(
                                        new GetEventsLogFilterMap(api.type())
                                                .withAccountIDS(accountID1)
                                )
                                .withLogins(logins)
                                .withTimestampFrom(timestamp1)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event5.getBean())
                        )
                },
                {
                        "Filter by accountID1 and accountID2",
                        new GetEventsLogRequestMap(api.type())
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withAccountIDS(accountID1, accountID2)
                                )
                                .withTimestampFrom(timestamp1)
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean()),
                                beanEquals((EventsLogItem) event5.getBean())
                        )
                },
                {
                        "Filter by campaignId",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withCampaignIDS(campaignId.intValue())
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event2.getBean())
                        )
                },
                {
                        "Filter by MoneyWarning event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYWARNING)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean())
                        )
                },
                {
                        "Filter by MoneyIn event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYIN)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event1.getBean()),
                                beanEquals((EventsLogItem) event2.getBean())
                        )
                },
                {
                        "Filter by MoneyOut event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYOUT)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event5.getBean())
                        )
                },
                {
                        "Filter by accountID1, accountID2 and MoneyWarning event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYWARNING)
                                                .withAccountIDS(accountID1, accountID2)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event3.getBean()),
                                beanEquals((EventsLogItem) event4.getBean())
                        )
                },
                {
                        "Filter by accountID2 and MoneyWarning event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYWARNING)
                                                .withAccountIDS( accountID2)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event4.getBean())
                        )
                },
                {
                        "Filter by MoneyInAccount event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYINACCOUNT)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event1.getBean())
                        )
                },
                {
                        "Filter by accountID1 and MoneyWarningAccount event type",
                        new GetEventsLogRequestMap(api.type())
                                .withTimestampFrom(timestamp1)
                                .withFilter(new GetEventsLogFilterMap(api.type())
                                                .withEventType(EventType.MONEYWARNINGACCOUNT)
                                                .withAccountIDS(accountID1)
                                )
                                .withLogins(logins)
                                .withWithTextDescription(Value.YES),
                        hasItems(
                                beanEquals((EventsLogItem) event3.getBean())
                        )
                }
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5526")
    public void getEventsByFilter() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(filter.withCurrency(CLIENT_CURRENCY));
        assertThat("ответ содержит ожидаемые события", Arrays.asList(events), containsEvents);
    }
}
