package ru.yandex.autotests.directapi.campaigns.geteventslog.account;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import java.util.Arrays;

import static org.hamcrest.Matchers.hasItems;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;

/**
 * User: mariabye
 * Date: 31.10.13
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.SHARED_ACCOUNT)
public class GetAccountEventsTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String AGENCY_LOGIN = CampaignLogins.AGENCY_ACCOUNT;
    private static String SUB_CLIENT = CampaignLogins.AGENCY_ACCOUNT_SUB_CLIENT1;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    static int accountID;

    @BeforeClass
    public static void addCampaignToResources() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(AGENCY_LOGIN);
        api.userSteps.financeSteps().verifySharedAccount(SUB_CLIENT);
        accountID = api.userSteps.financeSteps().getAccountID(SUB_CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5528")
    public void getMoneyInFakeEvent() {
        int accountID = api.userSteps.financeSteps().getAccountID(SUB_CLIENT);
        String timestamp1 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap event = new EventsLogItemMap(api.type()).moneyInAccountEvent(accountID, 15f);
        api.userSteps.eventLogFakeSteps().addEvents(event);

        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(SUB_CLIENT)
                        .withWithTextDescription(Value.YES)
                        .withCurrency(CLIENT_CURRENCY)

        );
        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals((EventsLogItem) EventsLogItemMap.expectedMoneyInAccountEvent(event).getBean())));

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5527")
    public void getMoneyInRealEvent() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();

        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(accountID, 354f, Currency.RUB);

        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withLogins(SUB_CLIENT)
                        .withCurrency(CLIENT_CURRENCY)

        );
        EventsLogItemMap expectedEvent = new EventsLogItemMap(api.type()).
                expectedMoneyInAccountEvent(new EventsLogItemMap(api.type())
                        .moneyInAccountEvent(accountID, 300f, Currency.RUB.toString()))
                .withTextDescription(null);

        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals((EventsLogItem) expectedEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5529")
    public void getMoneyWarningFakeEvent() {
        int accountID = api.userSteps.financeSteps().getAccountID(SUB_CLIENT);
        String timestamp1 = api.userSteps.changesSteps().getTimestamp();

        EventsLogItemMap moneyWarningEvent = new EventsLogItemMap(api.type()).moneyWarningAccountEvent(accountID, 15f);
        api.userSteps.eventLogFakeSteps().addEvents(moneyWarningEvent);

        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(SUB_CLIENT)
                        .withWithTextDescription(Value.YES)
                        .withCurrency(CLIENT_CURRENCY)

        );
        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals(
                        (EventsLogItem) EventsLogItemMap.expectedMoneyWarningAccountEvent(moneyWarningEvent).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5530")
    public void getMoneyOutFakeEvent() {
        int accountID = api.userSteps.financeSteps().getAccountID(SUB_CLIENT);
        String timestamp1 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap moneyOutEvent = new EventsLogItemMap(api.type()).moneyOutAccountEvent(accountID);
        api.userSteps.eventLogFakeSteps().addEvents(moneyOutEvent);

        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(SUB_CLIENT)
                        .withWithTextDescription(Value.YES)
                        .withCurrency(CLIENT_CURRENCY)

        );

        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals(
                        (EventsLogItem) EventsLogItemMap.expectedMoneyOutAccountEvent(moneyOutEvent).getBean())));
    }

    @After
    public void clearAccount() {
        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(accountID, 0f, Currency.RUB);
    }
}
