package ru.yandex.autotests.directapi.campaigns.geteventslog.account;

import java.util.Arrays;

import org.junit.After;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventName;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItems;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * User: mariabye
 * Date: 31.10.13
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Tag(TagDictionary.TRUNK)
public class GetNoAccountEventsTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String AGENCY_LOGIN = CampaignLogins.AGENCY_ACCOUNT;
    private static String SUB_CLIENT_NO_ACCOUNT = CampaignLogins.AGENCY_ACCOUNT_SUB_CLIENT_NO_ACCOUNT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static String campaignName;

    @BeforeClass
    public static void campaignName() {
        campaignName = "Тестовая кампания API";
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withDefaultTextCampaign().withName(campaignName),
                SUB_CLIENT_NO_ACCOUNT);
        api.clientLogin(SUB_CLIENT_NO_ACCOUNT);
        api.userSteps.addCompletedAdGroup(campaignId);
        api.userSteps.makeCampaignModerated(campaignId.intValue());

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5532")
    public void getMoneyInFakeEvent(){
        String timestamp1 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap event = new EventsLogItemMap(api.type()).moneyInEvent(campaignId.intValue(), 15f);

        api.userSteps.eventLogFakeSteps().addEvents(event);
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(SUB_CLIENT_NO_ACCOUNT)
                        .withWithTextDescription(Value.YES)
                        .withCurrency(CLIENT_CURRENCY)
        );
        event.withEventName(TextResourceFormatter.resource(EventName.MONEY_IN).toString())
                .withTextDescription(campaignName).withTimestamp(null);
        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals((EventsLogItem) event.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5531")
    public void getMoneyInRealEvent() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();

        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(campaignId, 354f, Currency.RUB);

        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withLogins(SUB_CLIENT_NO_ACCOUNT)
                        .withCurrency(CLIENT_CURRENCY)
        );

        EventsLogItemMap expectedEvent = new EventsLogItemMap(api.type())
                .moneyInEvent(campaignId.intValue(), 300f, Currency.RUB.toString())
                .withEventName(TextResourceFormatter.resource(EventName.MONEY_IN).toString())
                .withTextDescription(null).withTimestamp(null);

        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals(
                        (EventsLogItem) expectedEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5533")
    public void getMoneyWarningFakeEvent() {
        String timestamp1 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap expectedEvent = new EventsLogItemMap(api.type()).moneyWarningEvent(campaignId.intValue(), 15f);
        api.userSteps.eventLogFakeSteps().addEvents(expectedEvent);

        EventsLogItem[] events =  api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(SUB_CLIENT_NO_ACCOUNT)
                        .withWithTextDescription(Value.YES)
                        .withCurrency(CLIENT_CURRENCY)
        );

        expectedEvent.withEventName(TextResourceFormatter.resource(EventName.MONEY_WARNING).toString())
                .withTextDescription(campaignName).withTimestamp(null);

        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals(
                        (EventsLogItem) expectedEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5534")
    public void getMoneyOutFakeEvent() {
        String timestamp1 = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap expectedEvent = new EventsLogItemMap(api.type()).moneyOutEvent(campaignId.intValue());
        api.userSteps.eventLogFakeSteps().addEvents(expectedEvent);

        EventsLogItem[] events =  api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(SUB_CLIENT_NO_ACCOUNT)
                        .withWithTextDescription(Value.YES)
                        .withCurrency(CLIENT_CURRENCY)
        );
        expectedEvent.withEventName(TextResourceFormatter.resource(EventName.MONEY_OUT).toString())
                .withTextDescription(campaignName).withTimestamp(null);

        assertThat("присутствует событие", Arrays.asList(events),
                hasItems(beanEquals(
                        (EventsLogItem) expectedEvent.getBean())));
    }

    @After
    public void clearAccount() {
        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(campaignId, 0f, Currency.RUB);
    }
}
