package ru.yandex.autotests.directapi.campaigns.geteventslog.campaign;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventName;
import ru.yandex.autotests.directapi.model.geteventslog.EventType;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Migrated from old school project (api4l)
 * <br/>
 * Created by chicos on 04.02.14.<br/>
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Tag(TagDictionary.TRUNK)
public class GetPausedByDayBudgetEventsTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String CLIENT_LOGIN = CampaignLogins.SELF_CLIENT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    private static EventsLogItemMap campaignEvent;

    private static String timestampBefore;
    private static String timestampAfter;

    private static Long campaignId;
    private static final String campaignName = "Тестовая кампания API";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareEvents() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withDefaultTextCampaign().withName(campaignName)
        );

        timestampBefore = api.userSteps.changesSteps().getTimestamp();
        campaignEvent = new EventsLogItemMap(api.type()).
                pausedByDayBudgetEvent(campaignId.intValue(), timestampBefore);
        api.userSteps.eventLogFakeSteps().addEvents(campaignEvent);
        campaignEvent.withEventName(TextResourceFormatter.resource(EventName.PAUSED_BY_DAY_BUDGET).toString())
                .withTimestamp(null);
        timestampAfter = api.userSteps.changesSteps().getTimestamp();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5559")
    public void getEventByEmptyFilter() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withCurrency(CLIENT_CURRENCY)
        );

        campaignEvent.withTextDescription(null);
        assertThat("присутствует событие", Arrays.asList(events),
                hasItem(beanEquals((EventsLogItem) campaignEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5560")
    public void getEventByPausedByDayBudgetType() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withEventType(EventType.PAUSEDBYDAYBUDGET))
        );

        campaignEvent.withTextDescription(null);
        assertThat("присутствует событие", Arrays.asList(events),
                hasItem(beanEquals((EventsLogItem) campaignEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5561")
    public void getEventByCampaignId() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withCampaignIDS(campaignId.intValue()))
        );

        campaignEvent.withTextDescription(null);
        assertThat("присутствует событие", Arrays.asList(events),
                hasItem(beanEquals((EventsLogItem) campaignEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5562")
    public void getEventWithTextDescription() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withCurrency(CLIENT_CURRENCY)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withEventType(EventType.PAUSEDBYDAYBUDGET)
                                .withCampaignIDS(campaignId.intValue()))
                        .withWithTextDescription(Value.YES)
        );

        campaignEvent.withTextDescription(campaignName);
        assertThat("присутствует событие", Arrays.asList(events),
                hasItem(beanEquals((EventsLogItem) campaignEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5563")
    public void getEventWithLastEventOnly() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestampBefore)
                        .withCurrency(CLIENT_CURRENCY)
                        .withWithTextDescription(Value.YES)
                        .withLastEventOnly(Value.YES)
        );

        campaignEvent.withTextDescription(campaignName);
        assertThat("присутствует событие", Arrays.asList(events),
                hasItem(beanEquals((EventsLogItem) campaignEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5564")
    public void getEventWithTimestampAfterEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withCurrency(CLIENT_CURRENCY)
                        .withTimestampFrom(timestampAfter)
        );

        campaignEvent.withTextDescription(null);
        assertThat("отсутствует некоторое событие", Arrays.asList(events),
                not(hasItem(beanEquals((EventsLogItem) campaignEvent.getBean()))));
    }
}
