package ru.yandex.autotests.directapi.campaigns.geteventslog.currency;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Migrated from old school project (api45)
 * <p/>
 * Created by chicos on 29.01.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */

@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
public class GetEventsLogCurrencyNegativeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientRUB = CampaignLogins.SELF_CLIENT;
    private static String timestamp1;
    private static Long campaignId1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientRUB);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareEvents() {
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        timestamp1 = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(campaignId1, 10f, Currency.RUB);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5566")
    public void invalidCurrencyWithEmptyFilter() {
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.GET_EVENTS_LOG,
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withCurrency("WrongCurrency")
                        .withWithTextDescription(Value.YES),
                new AxisError(245, AxisErrorDetails.EMPTY_STRING)
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5565")
    public void invalidCurrencyWithFilter() {
        api.userSteps.campaignSteps().shouldGetErrorOn(
                Method.GET_EVENTS_LOG,
                new GetEventsLogRequestMap(api.type())
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withCampaignIDS(campaignId1.intValue()))
                        .withTimestampFrom(timestamp1)
                        .withCurrency("WrongCurrency")
                        .withWithTextDescription(Value.YES),
                new AxisError(245, AxisErrorDetails.EMPTY_STRING)
        );
    }
}
