package ru.yandex.autotests.directapi.campaigns.geteventslog.currency;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Migrated from old school project (api45)
 * <p>
 * Created by chicos on 29.01.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */

@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.CURRENCY)
@RunWith(Parameterized.class)
public class GetEventsLogCurrencyNonRubTest {
    //DIRECT-56824
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private String clientCurrency;
    private String beforeTime;
    private Long campaignId;

    @Parameterized.Parameter(value = 0)
    public String clientLogin;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameters(name = "login = {0}")
    public static Collection payments() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_FOR_UAH},
                {Logins.LOGIN_FOR_KZT},
                {Logins.LOGIN_FOR_CHF},
                {Logins.LOGIN_FOR_TRY},
                {Logins.LOGIN_FOR_USD},
                {Logins.LOGIN_FOR_EUR},
                {Logins.CLIENT_BYN}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initCurrencyRates() {
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runFillCurrencyRates();
    }

    @Before
    public void prepareEvent() {
        campaignId = api.as(clientLogin).userSteps.campaignSteps().addDefaultTextCampaign();

        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        clientCurrency = clientInfo.getClientCurrencies()[0];

        beforeTime = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap event = new EventsLogItemMap(api.type()).moneyWarningEvent(campaignId.intValue(), 10f, clientCurrency);
        api.userSteps.eventLogFakeSteps().addEvents(event);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5567")
    public void getEventsLogWithClientCurrency() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(beforeTime)
                        .withCurrency(clientCurrency)
        );
        List<String> currencies = extract(events, on(EventsLogItem.class).getAttributes().getCurrency());

        assertThat("корректное значение валюты в ответе", currencies, everyItem(equalTo(clientCurrency)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5569")
    public void getEventsLogWithNonClientCurrency() {
        EventsLogItem[] events = api.as(clientLogin).userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(beforeTime)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withCampaignIDS(campaignId.intValue()))
                        .withCurrency(Currency.RUB)

        );
        List<String> responseCurrencies = extract(events, on(EventsLogItem.class).getAttributes().getCurrency());

        assertThat("корректное значение валюты в ответе", responseCurrencies, everyItem(equalTo(Currency.RUB.toString())));
    }
}
