package ru.yandex.autotests.directapi.campaigns.geteventslog.currency;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Migrated from old school project (api45)
 * <br/>
 * Created by chicos on 29.01.14.<br/>
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */

@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.CURRENCY)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetEventsLogCurrencyTest {
    //DIRECT-56824

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientRUB = CampaignLogins.SELF_CLIENT;
    private static final String clientYE = Logins.CLIENT_FREE_YE_DEFAULT;
    private static String timestamp1;
    private static Long campaignId1;
    private static Long campaignId2;

    @Parameterized.Parameter
    public String clientLogin;

    @Parameterized.Parameter(1)
    public String currency;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @BeforeClass
    public static void prepareEvents() {
        api.userSteps.getDarkSideSteps().getRunScriptSteps().runFillCurrencyRates();
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaign(clientRUB);
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(clientYE);

        timestamp1 = api.userSteps.changesSteps().getTimestamp();
        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(campaignId1, 10f, Currency.RUB);
    }

    @Parameterized.Parameters(name = "login = {0}, request currency = {1}")
    public static Collection currencies() {
        Object[][] data = new Object[][]{
                {clientRUB, Currency.RUB.toString()},
                {clientRUB, Currency.USD.toString()},
                {clientRUB, Currency.BYN.toString()},
                {clientYE, Currency.RUB.toString()},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5570")
    public void getEventsLogWithSpecificCurrency() {
        EventsLogItem[] events = api.as(clientLogin).userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withCurrency(currency)
                        .withWithTextDescription(Value.YES)
                        .withFilter(new GetEventsLogFilterMap(api.type()).withCampaignIDS(campaignId1.intValue(), campaignId2.intValue()))
        );
        List<String> responseCurrencies = extract(events, on(EventsLogItem.class).getAttributes().getCurrency());

        assertThat("корректное значение валюты в ответе", responseCurrencies, everyItem(equalTo(currency)));
    }
}
