package ru.yandex.autotests.directapi.campaigns.geteventslog.nds;

import java.math.RoundingMode;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.geteventslog.EventType;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.ConditionFactories;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
public class GetEventsLogClientNdsTest {

    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String LOGIN = Logins.LOGIN_FOR_RUB;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.LOGIN_FOR_RUB);

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private Long clientId;

    @Before
    public void before() {
        clientId = Long.valueOf(User.get(LOGIN).getClientID());
    }

    @Test
    public void getEventsLog_PaymentFrom2003_AmountMustBeCountedWithNds20() {
        Long cid = api.userSteps.addActiveCampaign(Logins.LOGIN_FOR_RUB, 1200.0f * 2, Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(cid));

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).eventLogSteps().moveAllEventsInTime(clientId, cid,
                "2003-06-15 00:00:00");

        EventsLogItem[] eventsLog = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withLogins(LOGIN)
                        .withCurrency(Currency.RUB)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withEventType(EventType.MONEYIN)
                                .withCampaignIDS(cid.intValue()))
                        .withTimestampFrom("2003-06-14T00:00:00Z")
                        .withTimestampTo("2003-06-16T00:00:00Z"));

        assumeThat("Вернулось одно событие", eventsLog.length, is(1));
        EventsLogItem logItem = eventsLog[0];

        assumeThat("У события правильно проставлена дата", logItem.getTimestamp(), is("2003-06-14T20:00:00Z"));

        assertThat("Счет пополнился на сумму с НДС 20%", logItem.getAttributes().getPayed(), is(1000.0f * 2));
    }

    @Test
    public void getEventsLog_PaymentFrom2004_AmountMustBeCountedWithNds18() {
        Long cid = api.userSteps.addActiveCampaign(Logins.LOGIN_FOR_RUB, 1180.0f * 2, Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(cid));

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).eventLogSteps().moveAllEventsInTime(clientId, cid,
                "2004-06-15 00:00:00");

        EventsLogItem[] eventsLog = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withLogins(LOGIN)
                        .withCurrency(Currency.RUB)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withEventType(EventType.MONEYIN)
                                .withCampaignIDS(cid.intValue()))
                        .withTimestampFrom("2004-06-14T00:00:00Z")
                        .withTimestampTo("2004-06-16T00:00:00Z"));

        assumeThat("Вернулось одно событие", eventsLog.length, is(1));
        EventsLogItem logItem = eventsLog[0];

        assumeThat("У события правильно проставлена дата", logItem.getTimestamp(), is("2004-06-14T20:00:00Z"));

        assertThat("Счет пополнился на сумму с НДС 20%", logItem.getAttributes().getPayed(), is(1000.0f * 2));
    }

    @Test
    public void getEventsLog_PaymentsFrom2004AndNow_DifferentSubclients_AmountsMustBeCountedWithDifferentNds() {
        Long cid = api.userSteps.addActiveCampaign(Logins.LOGIN_FOR_RUB, 1180.0f * 2, Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(cid));

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).eventLogSteps().moveAllEventsInTime(clientId, cid,
                "2004-06-15 00:00:00");

        Long cid2 = api.userSteps.addActiveCampaign(Logins.LOGIN_FOR_RUB, 1200.0f * 2, Currency.RUB);

        ConditionFactories.NOTIFY_ORDER2.until(api.userSteps.campaignSteps().campaignFundsChanged(cid2));

        EventsLogItem[] eventsLog = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withLogins(LOGIN)
                        .withCurrency(Currency.RUB)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withEventType(EventType.MONEYIN)
                                .withCampaignIDS(cid.intValue(), cid2.intValue()))
                        .withTimestampFrom("2004-06-14T00:00:00Z"));

        assumeThat("Вернулось два события", eventsLog.length, is(2));

        sortEvents(eventsLog, "2004-06-14T20:00:00Z");

        assumeThat("У события правильно проставлена дата", eventsLog[0].getTimestamp(), is("2004-06-14T20:00:00Z"));

        assertThat("Счет пополнился на сумму с НДС 18%", eventsLog[0].getAttributes().getPayed(), is(1000.0f * 2));
        assertThat("Счет пополнился на сумму с текущим НДС", eventsLog[1].getAttributes().getPayed(),
                is(Money.valueOf(1200.0f * 2, Currency.RUB).subtractVAT().setScale(2, RoundingMode.UP).floatValue()));
    }

    private void sortEvents(EventsLogItem[] eventsLog, String firstTimestamp) {
        if (!eventsLog[0].getTimestamp().equals(firstTimestamp)) {
            EventsLogItem tmp = eventsLog[1];
            eventsLog[1] = eventsLog[0];
            eventsLog[0] = tmp;
        }
    }
}
