package ru.yandex.autotests.directapi.campaigns.geteventslog.sharding;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.EventlogRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.common.api45.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.banners.BannerModerationResult;
import ru.yandex.autotests.directapi.model.banners.phrases.BannerPhraseInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.geteventslog.EventName;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemAttributesMap;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.UserSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.direct.utils.matchers.BeanEquals.beanEquals;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 22.01.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Stories(ApiStories.SHARDING)
public class AllTypesGetEventsLogShardingTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String AGENCY_ACCOUNT = CampaignLogins.AGENCY_ACCOUNT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;
    private static String subClientLogin;

    private static EventsLogItemMap event1;
    private static EventsLogItemMap event2;
    private static EventsLogItemMap event3;
    private static EventsLogItemMap event4;
    private static EventsLogItemMap event5;
    private static EventsLogItemMap event6;
    private static EventsLogItemMap event7;

    private static String timestamp1;
    private static String timestamp2;
    private static String timestamp3;
    private static String timestamp4;
    private static String timestamp5;
    private static String timestamp6;
    private static String timestamp7;

    private static String bannerTitle;
    private static String bannerPhrase;
    private static Long campaignId;
    private static final String CAMPAIGN_NAME = "Кампания API для событий";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_ACCOUNT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);

    private static int accountId;

    private static long clientId;

    @BeforeClass
    public static void prepareEvents() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(AGENCY_ACCOUNT);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(AGENCY_ACCOUNT);
        api.userSteps.clientFakeSteps().reshardUserWithLock(AGENCY_ACCOUNT, ShardNumbers.DEFAULT_SHARD);
        CreateNewSubclientResponse subClient = api.as(AGENCY_ACCOUNT).userSteps.clientSteps()
                .createNewAgencySubClient("at-events", AGENCY_ACCOUNT, CLIENT_CURRENCY);
        subClientLogin = subClient.getLogin();
        clientId = subClient.getClientID();
        api.userSteps.clientFakeSteps().reshardUserWithLock(subClientLogin, ShardNumbers.EXTRA_SHARD);

        //создадим промодерированную кампанию, самостоятельно установили имя кампании
        campaignId = api.clientLogin(subClientLogin).userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withDefaultTextCampaign().withName(CAMPAIGN_NAME)
        );

        final UserSteps.AdGroupCreationResult adGroupCreationResult =
                api.userSteps.addCompletedAdGroupAndReturnCreationResult(campaignId);

        Long keyword2Id = adGroupCreationResult.getKeywordIds()[0];
        Long adId = adGroupCreationResult.getAdIds()[0];
        bannerPhrase = api.userSteps.keywordsSteps().keywordsGetById(keyword2Id).get(0).getKeyword();
        final AdGetItem ad = api.userSteps.adsSteps().adsGet(
                    new GetRequestMap().withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                            .withFieldNames(AdFieldEnum.ID).withTextAdFieldNames(TextAdFieldEnum.TITLE)
                ).getAds().get(0);

        api.userSteps.financeSteps().verifySharedAccount(subClientLogin);
        accountId = api.userSteps.financeSteps().getAccountID(subClientLogin);

        BannerPhraseInfoMap phrase = api.userSteps.creationResultToBannerPhraseInfo(campaignId, adGroupCreationResult);

        timestamp1 = api.userSteps.changesSteps().getTimestamp();
        //Странное поведение в debug - при присваивании бина campaignId -> accountID
        event1 = new EventsLogItemMap(api.type()).moneyInAccountEvent(accountId, 123f);
        api.userSteps.eventLogFakeSteps().addEvents(event1);
        event1 = event1.expectedMoneyInAccountEvent(event1);

        timestamp2 = api.userSteps.changesSteps().getTimestamp();
        event2 = new EventsLogItemMap(api.type()).moneyWarningAccountEvent(accountId, 715f);
        api.userSteps.eventLogFakeSteps().addEvents(event2);
        event2 = event2.expectedMoneyWarningAccountEvent(event2);

        timestamp3 = api.userSteps.changesSteps().getTimestamp();
        event3 = new EventsLogItemMap(api.type()).moneyOutAccountEvent(accountId);
        api.userSteps.eventLogFakeSteps().addEvents(event3);
        event3 = event3.expectedMoneyOutAccountEvent(event3);

        timestamp4 = api.userSteps.changesSteps().getTimestamp();
        bannerTitle = ad.getTextAd().getTitle();

        event4 = new EventsLogItemMap(api.type())
                .bannerModeratedEvent(
                        campaignId.intValue(), adId, BannerModerationResult.ACCEPTED, Value.YES);

        api.userSteps.eventLogFakeSteps().addEvents(event4);
        event4 = event4.withEventName(TextResourceFormatter.resource(EventName.BANNER_MODERATED).toString())
                .withTimestamp(null);

        timestamp5 = api.userSteps.changesSteps().getTimestamp();
        event5 = new EventsLogItemMap(api.type()).warnPlaceEvent(phrase, "12");
        api.userSteps.eventLogFakeSteps().addEvents(event5);
        event5 = event5.withEventName(TextResourceFormatter.resource(EventName.WARN_PLACE).toString())
                .withTimestamp(null);

        timestamp6 = api.userSteps.changesSteps().getTimestamp();
        event6 = new EventsLogItemMap(api.type())
                .campaignFinishedEvent(campaignId.intValue(), DateTime.now().toDate());
        api.userSteps.eventLogFakeSteps().addEvents(event6);
        event6 = event6.withEventName(TextResourceFormatter.resource(EventName.CAMPAIGN_FINISHED).toString())
                .withTimestamp(null);

        timestamp7 = api.userSteps.changesSteps().getTimestamp();
        event7 = new EventsLogItemMap(api.type()).pausedByDayBudgetEvent(campaignId.intValue(), timestamp7);
        api.userSteps.eventLogFakeSteps().addEvents(event7);
        event7 = event7.withEventName(TextResourceFormatter.resource(EventName.PAUSED_BY_DAY_BUDGET).toString())
                .withTimestamp(null);
    }

    @Test
    public void filterEventsUnavailableInApi() {
        EventsLogItem[] eventsLogBeforeAdd = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(subClientLogin)
                        .withCurrency(Currency.RUB)
        );

        EventlogRecord record = new EventlogRecord()
                .setClientid(clientId)
                .setCid(campaignId)
                .setType(18L) // strategy_data_sum_changed
                .setParams("{\"budget_before\": 10.0, \"budget_after\": 20.0}");
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(subClientLogin)
                .eventLogSteps().addEvent(record);

        EventsLogItem[] eventsLogAfterAdd = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withLogins(subClientLogin)
                        .withCurrency(Currency.RUB)
        );
        assertThat("Новых событий добавиться не должно",
                eventsLogBeforeAdd.length, equalTo(eventsLogAfterAdd.length));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5595")
    public void getMoneyInFakeEvent()  {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp1)
                        .withTimestampTo(timestamp2)
                        .withLogins(subClientLogin)
                        .withCurrency(CLIENT_CURRENCY)
                        .withWithTextDescription(Value.YES)
        );
        assertThat("присутствует событие", Arrays.asList(events), hasItem(beanEquals((EventsLogItem) event1.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5596")
    public void getMoneyWarningFakeEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp2)
                        .withTimestampTo(timestamp3)
                        .withCurrency(CLIENT_CURRENCY)
                        .withLogins(subClientLogin)
                        .withWithTextDescription(Value.YES)
        );
        assertThat("присутствует событие", Arrays.asList(events),hasItem(beanEquals((EventsLogItem) event2.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5597")
    public void getMoneyOutFakeEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp3)
                        .withTimestampTo(timestamp4)
                        .withCurrency(CLIENT_CURRENCY)
                        .withLogins(subClientLogin)
                        .withWithTextDescription(Value.YES)
        );
        assertThat("присутствует событие", Arrays.asList(events),hasItem(beanEquals((EventsLogItem) event3.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5594")
    public void getMoneyInRealEvent() {
        String timestamp = api.userSteps.changesSteps().getTimestamp();

        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(accountId, 118f, Currency.RUB);
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp)
                        .withLogins(subClientLogin)
                        .withCurrency(CLIENT_CURRENCY)
        );
        api.userSteps.campaignFakeSteps().sendFakeNotificationFromBalance(accountId, 0f, Currency.RUB);

        EventsLogItemMap expectedEvent = new EventsLogItemMap(api.type()).expectedMoneyInAccountEvent(
                new EventsLogItemMap(api.type()).moneyInAccountEvent(accountId, 100f))
                .withTextDescription(null)
                .withAttributes(
                        new EventsLogItemAttributesMap(api.type())
                                .withCurrency(Currency.RUB)
                );

        assertThat("присутствует событие", Arrays.asList(events), hasItem(beanEquals((EventsLogItem) expectedEvent.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5598")
    public void getBannerModeratedFakeEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp4)
                        .withTimestampTo(timestamp5)
                        .withCurrency(CLIENT_CURRENCY)
                        .withLogins(subClientLogin)
                        .withWithTextDescription(Value.YES)
        );
        event4.withTextDescription(bannerTitle);
        assertThat("присутствует событие", Arrays.asList(events), hasItem(beanEquals((EventsLogItem) event4.getBean())));
    }

    @Test
    //https://jira.yandex-team.ru/browse/DIRECT-28423
    @ru.yandex.qatools.allure.annotations.TestCaseId("5599")
    public void getWarnPlaceFakeEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp5)
                        .withTimestampTo(timestamp6)
                        .withCurrency(CLIENT_CURRENCY)
                        .withLogins(subClientLogin)
                        .withWithTextDescription(Value.YES)
        );
        event5.withTextDescription(bannerPhrase);
        assertThat("присутствует событие", Arrays.asList(events), hasItem(beanEquals((EventsLogItem) event5.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5601")
    public void getCampaignFinishedFakeEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp6)
                        .withTimestampTo(timestamp7)
                        .withLogins(subClientLogin)
                        .withCurrency(CLIENT_CURRENCY)
                        .withWithTextDescription(Value.YES)
        );
        event6.withTextDescription(CAMPAIGN_NAME);
        assertThat("присутствует событие", Arrays.asList(events), hasItem(beanEquals((EventsLogItem) event6.getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5603")
    public void getPausedByDayBudgetFakeEvent() {
        EventsLogItem[] events = api.userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(timestamp7)
                        .withLogins(subClientLogin)
                        .withCurrency(CLIENT_CURRENCY)
                        .withWithTextDescription(Value.YES)
        );
        event7.withTextDescription(CAMPAIGN_NAME);
        assertThat("присутствует событие", Arrays.asList(events), hasItem(beanEquals((EventsLogItem) event7.getBean())));
    }
}
