package ru.yandex.autotests.directapi.campaigns.geteventslog.smoke;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.common.api45.ClientInfo;
import ru.yandex.autotests.directapi.common.api45.EventsLogItem;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogFilterMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * User: ginger
 * Date: 14.07.14
 */
@Aqua.Test
@Features(CampaignFeatures.CURRENCY_MONITOR)
@Stories(CampaignFeatures.GET_EVENTS_LOG)
@RunWith(Parameterized.class)
public class CheckCurrencyTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private String clientCurrency;
    private String beforeTime;
    private Long campaignId;

    @Parameterized.Parameter(value = 0)
    public String clientLogin;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();


    @Parameterized.Parameters(name = "login = {0}")
    public static Collection payments() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_FOR_UAH},
                {Logins.LOGIN_FOR_EUR}
        };
        return Arrays.asList(data);
    }

    @Before
    public void prepareEvent() {
        campaignId = api.as(clientLogin).userSteps.campaignSteps().addDefaultTextCampaign();

        ClientInfo clientInfo = api.userSteps.clientSteps().getClientInfo(clientLogin);
        clientCurrency = clientInfo.getClientCurrencies()[0];

        DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        beforeTime = dateFormat.format(calendar.getTime());

        EventsLogItemMap event = new EventsLogItemMap(api.type()).moneyWarningEvent(campaignId.intValue(), 10f, clientCurrency);
        api.userSteps.eventLogFakeSteps().addEvents(event);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5604")
    public void getEventsLogWithNonClientCurrency() {
        EventsLogItem[] events = api.as(clientLogin).userSteps.getEventsLogSteps().getEventsLog(
                new GetEventsLogRequestMap(api.type())
                        .withTimestampFrom(beforeTime)
                        .withFilter(new GetEventsLogFilterMap(api.type())
                                .withCampaignIDS(campaignId.intValue()))
                        .withCurrency(Currency.RUB)

        );
        List<String> responseCurrencies = extract(events, on(EventsLogItem.class).getAttributes().getCurrency());

        assertThat("корректное значение валюты в ответе", responseCurrencies,
                everyItem(equalTo(Currency.RUB.toString())));
    }

}
