package ru.yandex.autotests.directapi.campaigns.geteventslog.validation;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.campaigns.CampaignFeatures;
import ru.yandex.autotests.directapi.campaigns.CampaignLogins;
import ru.yandex.autotests.directapi.model.geteventslog.EventsLogItemMap;
import ru.yandex.autotests.directapi.model.geteventslog.GetEventsLogRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Migrated from old school project (api4l)
 * <br/>
 * Created by chicos on 06.02.14.<br/>
 * https://jira.yandex-team.ru/browse/TESTIRT-1400
 */
@Aqua.Test
@Features(CampaignFeatures.GET_EVENTS_LOG)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class GetEventsRequestValidateLoginsForAgencyTest {

    private static LogSteps log = LogSteps.getLogger(GetEventsRequestValidateLoginsForAgencyTest.class);

    private static final String CLIENT_LOGIN = CampaignLogins.SUB_CLIENT;
    private static final String AGENCY_LOGIN = CampaignLogins.AGENCY;
    private static final String NO_RIGHT_LOGIN = CampaignLogins.SELF_CLIENT;
    private static final Currency CLIENT_CURRENCY = Currency.RUB;

    private static String timestampBefore;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

	@Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameter
    public Object logins;

    @Parameterized.Parameter(1)
    public AxisError expectedAxisError;

    @Parameterized.Parameters(name = "logins = {0}, axis error = {1}")
    public static Collection timestampTemplate() {
        Object[][] data = new Object[][]{
                {null, new AxisError(9, AxisErrorDetails.LOGINS_FIELD)},
                {"undef", new AxisError(9, AxisErrorDetails.LOGINS_FIELD)},
                {new String[]{null},
                        new AxisError(251, AxisErrorDetails.FIELD_SHOULD_BE_A_LOGIN_ARRAY, "Logins")},
                {CLIENT_LOGIN, new AxisError(9, AxisErrorDetails.LOGINS_FIELD)},
                {Arrays.asList(), new AxisError(71, AxisErrorDetails.FIELD_IS_REQUIRED_FOR_AGENCY, "Logins")},
                {Arrays.asList(123), new AxisError(54, AxisErrorDetails.EMPTY_STRING)},
                {Arrays.asList(123f), new AxisError(54, AxisErrorDetails.EMPTY_STRING)},
                {Arrays.asList("123&^%"),
                        new AxisError(251, AxisErrorDetails.FIELD_SHOULD_BE_A_LOGIN_ARRAY, "Logins")},
                {Arrays.asList(""),
                        new AxisError(251, AxisErrorDetails.FIELD_SHOULD_BE_A_LOGIN_ARRAY, "Logins")},
                {Arrays.asList(NO_RIGHT_LOGIN), new AxisError(54, AxisErrorDetails.EMPTY_STRING)},
                {Arrays.asList(CLIENT_LOGIN, NO_RIGHT_LOGIN), new AxisError(54, AxisErrorDetails.EMPTY_STRING)}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
      public static void prepareEvent() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT_LOGIN);

        timestampBefore = api.userSteps.changesSteps().getTimestamp();
        EventsLogItemMap finishedEvent = new EventsLogItemMap(api.type())
                .campaignFinishedEvent(campaignId.intValue(), DateTime.now().toDate());
        api.userSteps.eventLogFakeSteps().addEvents(finishedEvent);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5605")
    public void getEventBySubclientLoginField() throws ParseException {
        //https://jira.yandex-team.ru/browse/DIRECT-29066
        GetEventsLogRequestMap getEventsLogRequestMap = new GetEventsLogRequestMap(api.type())
                .withCurrency(CLIENT_CURRENCY)
                .withTimestampFrom(timestampBefore);

        JSONObject eventsLogBean = (JSONObject)(new JSONParser()
                .parse(JsonUtils.toString(getEventsLogRequestMap.getBean())));
        eventsLogBean.put(StringUtils.capitalize(GetEventsLogRequestMap.LOGINS), logins);
        api.userSteps.shouldGetErrorOn(Method.GET_EVENTS_LOG, eventsLogBean, expectedAxisError);
    }
}
